/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays2 {
    private Arrays2() {
    }

    public static final boolean containsAll(Object[] array, Object ... values) {
        return Arrays.asList(array).containsAll(Arrays.asList(values));
    }

    public static final boolean unorderedEquals(Object[] array, Object ... values) {
        return Arrays2.containsAll(array, values) && array.length == values.length;
    }

    public static <T> Set<T> asSet(T ... types) {
        HashSet<T> result = new HashSet<T>();
        for (T type : types) {
            result.add(type);
        }
        return result;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return Arrays2.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

