/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.mdb.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapter;
import org.ow2.easybeans.container.mdb.helper.IResourceAdapterFinder;

public class JOnAS4ResourceAdapterFinder
implements IResourceAdapterFinder {
    private static final String JONAS_4_RAR_CLASS = "org.objectweb.jonas.resource.Rar";

    public ResourceAdapter getResourceAdapter(String jndiName) throws ResourceException {
        Class<?> rarClass = null;
        try {
            rarClass = Thread.currentThread().getContextClassLoader().loadClass(JONAS_4_RAR_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ResourceException("Cannot find the JOnAS resource adapter class", (Throwable)cnfe);
        }
        Method getRarMethod = null;
        try {
            getRarMethod = rarClass.getMethod("getRar", String.class);
        }
        catch (SecurityException e) {
            throw new ResourceException("Cannot get the getRar method on the class '" + rarClass + "'.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceException("Cannot get the getRar method on the class '" + rarClass + "'.", (Throwable)e);
        }
        Object rarObject = null;
        try {
            rarObject = getRarMethod.invoke(null, jndiName);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException("Cannot invoke method with jndiName '" + jndiName + "'.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException("Cannot invoke method with jndiName '" + jndiName + "'.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ResourceException("Cannot invoke method with jndiName '" + jndiName + "'.", e.getTargetException());
        }
        Method getResourceAdapterMethod = null;
        try {
            getResourceAdapterMethod = rarObject.getClass().getMethod("getResourceAdapter", new Class[0]);
        }
        catch (SecurityException e) {
            throw new ResourceException("Cannot get the getResourceAdapter method on the class '" + rarObject.getClass() + "'.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceException("Cannot get the getResourceAdapter method on the class '" + rarObject.getClass() + "'.", (Throwable)e);
        }
        Object resourceAdapterObj = null;
        try {
            resourceAdapterObj = getResourceAdapterMethod.invoke(rarObject, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException("Cannot invoke method getResourceAdapter on the rar object.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceException("Cannot invoke method getResourceAdapter on the rar object.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ResourceException("Cannot invoke method getResourceAdapter on the rar object.", (Throwable)e);
        }
        ResourceAdapter resourceAdapter = null;
        if (!(resourceAdapterObj instanceof ResourceAdapter)) {
            throw new ResourceException("Object found is not an instance of ResourceAdapter");
        }
        resourceAdapter = (ResourceAdapter)resourceAdapterObj;
        return resourceAdapter;
    }
}

