/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.osgi.util.BCMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleArchive
implements Archive {
    private final URL url;
    private Enumeration<URL> urlEntries = null;
    private List<String> entries = null;

    public BundleArchive(URL url) {
        this.url = url;
        this.entries = new ArrayList<String>();
        BCMapper mapper = BCMapper.getInstance();
        BundleContext bc = (BundleContext)mapper.get((Object)url);
        this.urlEntries = bc.getBundle().findEntries("", "*", true);
        while (this.urlEntries.hasMoreElements()) {
            URL urlEntry = this.urlEntries.nextElement();
            String entryName = urlEntry.toString().substring(url.toString().length());
            this.entries.add(entryName);
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        URL subEntry = new URL(this.url, entryPath);
        InputStream is = null;
        try {
            is = subEntry.openStream();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL subEntry = new URL(this.url, entryPath);
        try {
            InputStream is = subEntry.openStream();
            if (is == null) {
                return null;
            }
            is.close();
        }
        catch (IOException ioe) {
            return null;
        }
        return subEntry;
    }

    @Override
    public URL getRootURL() {
        return this.url;
    }
}

