/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class ReferenceResolver {
    public static final String KEY = "REFERENCE_RESOLVER";
    private ArrayList references = new ArrayList();

    public static ReferenceResolver getInstance(Session unitOfWork) {
        if (unitOfWork == null) {
            return null;
        }
        return (ReferenceResolver)unitOfWork.getProperty(KEY);
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    private void createPKVectorsFromMap(Reference reference) {
        XMLCollectionReferenceMapping mapping = (XMLCollectionReferenceMapping)reference.getMapping();
        Vector pks = new Vector();
        Vector<String> pkFields = mapping.getReferenceDescriptor().getPrimaryKeyFieldNames();
        if (pkFields.size() <= 0) {
            return;
        }
        boolean init = true;
        Iterator<String> pkFieldNameIt = pkFields.iterator();
        while (pkFieldNameIt.hasNext()) {
            int i;
            Vector pkVals = (Vector)reference.getPrimaryKeyMap().get(pkFieldNameIt.next());
            if (pkVals == null) {
                return;
            }
            if (init) {
                for (i = 0; i < pkVals.size(); ++i) {
                    pks.add(new Vector());
                }
                init = false;
            }
            for (i = 0; i < pkVals.size(); ++i) {
                Object val = pkVals.get(i);
                ((Vector)pks.get(i)).add(val);
            }
        }
        reference.primaryKeys = pks;
    }

    public Reference getReference(XMLObjectReferenceMapping mapping, Object sourceObject) {
        for (int x = 0; x < this.references.size(); ++x) {
            Reference reference = (Reference)this.references.get(x);
            if (reference.getMapping() != mapping || reference.getSourceObject() != sourceObject) continue;
            return reference;
        }
        return null;
    }

    public void resolveReferences(AbstractSession session) {
        for (int x = 0; x < this.references.size(); ++x) {
            Reference reference = (Reference)this.references.get(x);
            if (reference.getMapping() instanceof XMLCollectionReferenceMapping) {
                XMLCollectionReferenceMapping mapping = (XMLCollectionReferenceMapping)reference.getMapping();
                ContainerPolicy cPolicy = mapping.getContainerPolicy();
                Object container = cPolicy.containerInstance();
                this.createPKVectorsFromMap(reference);
                for (Vector pkVector : reference.getPrimaryKeys()) {
                    Object value = session.getIdentityMapAccessor().getFromIdentityMap(pkVector, reference.getTargetClass());
                    if (value == null) continue;
                    cPolicy.addInto(value, container, session);
                }
                mapping.setAttributeValueInObject(reference.getSourceObject(), container);
                continue;
            }
            if (!(reference.getMapping() instanceof XMLObjectReferenceMapping)) continue;
            Object value = session.getIdentityMapAccessor().getFromIdentityMap(reference.getPrimaryKeys(), reference.getTargetClass());
            if (value != null) {
                ((XMLObjectReferenceMapping)reference.getMapping()).setAttributeValueInObject(reference.getSourceObject(), value);
            }
            if (null == reference.getSetting()) continue;
            reference.getSetting().setValue(value);
        }
        if (session.isUnitOfWork()) {
            ((UnitOfWork)((Object)session)).release();
        }
        this.references = new ArrayList();
    }
}

