/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared;

public final class DestinationConstants {
    public static final byte TOPIC_TYPE = 1;
    public static final byte QUEUE_TYPE = 2;
    public static final byte TEMPORARY = 16;
    private static final byte DESTINATION_TYPE = 3;

    public static final boolean compatible(byte type1, byte type2) {
        return (type1 & 3) == (type2 & 3);
    }

    public static final boolean isQueue(byte type) {
        return (type & 2) != 0;
    }

    public static final boolean isTopic(byte type) {
        return (type & 1) != 0;
    }

    public static final boolean isTemporary(byte type) {
        return (type & 0x10) != 0;
    }

    public static final byte getQueueType() {
        return 2;
    }

    public static final byte getTopicType() {
        return 1;
    }

    public static final byte getTemporaryQueueType() {
        return 18;
    }

    public static final byte getTemporaryTopicType() {
        return 17;
    }

    public static final void checkId(String id) throws Exception {
        if (id == null) {
            throw new Exception("Undefined (null) destination identifier.");
        }
        if (id.matches("#\\d+\\.\\d+\\.\\d+")) {
            return;
        }
        throw new Exception("Bad destination identifier:" + id);
    }

    public static final String getNullId(int serverId) {
        StringBuilder strbuf = new StringBuilder(10);
        strbuf.append("#").append(serverId).append('.').append(serverId).append(".0");
        return strbuf.toString();
    }

    public static final String getAdminTopicId(int serverId) {
        StringBuilder strbuf = new StringBuilder(10);
        strbuf.append("#").append(serverId).append('.').append(serverId).append('.').append(".10");
        return strbuf.toString();
    }
}

