/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.BundleArchive;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryArchive;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryInsideJarURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarFileArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarInputStreamURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.URLArchive;

public class ArchiveFactoryImpl {
    private final Logger logger;

    public ArchiveFactoryImpl() {
        this(Logger.global);
    }

    public ArchiveFactoryImpl(Logger logger) {
        this.logger = logger;
    }

    public Archive createArchive(URL url) throws URISyntaxException, IOException {
        Archive result;
        this.logger.entering("ArchiveFactoryImpl", "createArchive", new Object[]{url});
        String protocol = url.getProtocol();
        this.logger.logp(Level.FINER, "ArchiveFactoryImpl", "createArchive", "protocol = {0}", protocol);
        if ("bundle".equals(protocol) || "bundleentry".equals(protocol)) {
            result = new BundleArchive(url);
        } else if ("file".equals(protocol)) {
            File f;
            URI uri = Helper.toURI(url);
            try {
                f = new File(uri);
            }
            catch (IllegalArgumentException e) {
                f = new File(url.getPath());
            }
            result = f.isDirectory() ? new DirectoryArchive(f) : new JarFileArchive(new JarFile(f));
        } else {
            JarURLConnection conn;
            JarEntry je;
            result = "jar".equals(protocol) ? ((je = (conn = (JarURLConnection)JarURLConnection.class.cast(url.openConnection())).getJarEntry()) == null ? new JarFileArchive(conn.getJarFile()) : (je.isDirectory() ? new DirectoryInsideJarURLArchive(url) : new JarInputStreamURLArchive(url))) : (this.isJarInputStream(url) ? new JarInputStreamURLArchive(url) : new URLArchive(url));
        }
        this.logger.exiting("ArchiveFactoryImpl", "createArchive", result);
        return result;
    }

    private boolean isJarInputStream(URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            if (in == null) {
                return false;
            }
            JarInputStream jis = new JarInputStream(in);
            jis.close();
            return true;
        }
        catch (IOException ioe) {
            if (in != null) {
                in.close();
            }
            return false;
        }
    }
}

