/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp1Desc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.lib.ejb21.EntityCounters;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JContext;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityHome;
import org.ow2.jonas.lib.ejb21.JEntityLocalHome;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCRC;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCRU;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCRW;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCS;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCST;
import org.ow2.jonas.lib.ejb21.JEntitySwitchDB;
import org.ow2.jonas.lib.ejb21.JEntitySwitchRO;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JHome;
import org.ow2.jonas.lib.ejb21.JLocalHome;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.ejb21.TxListener;

public class JEntityFactory
extends JFactory
implements TimerService {
    protected JEntityHome home = null;
    protected JEntityLocalHome localhome = null;
    protected int lockPolicy;
    protected boolean prefetch = false;
    protected boolean cmp2 = true;
    protected boolean shared = false;
    protected boolean reentrant;
    protected int readTimeout;
    private int inactivityTimeout;
    private int deadlockTimeout;
    private int passivationTimeout;
    protected Object datasource = null;
    String dsname = null;
    protected List bctxlist = new ArrayList();
    protected int instanceCount = 0;
    protected boolean hardLimit = false;
    private int currentWaiters = 0;
    private long waiterTimeout = 10000L;
    private HashMap pklist = new HashMap();
    private LinkedList dirtyList = new LinkedList();
    private boolean mustSyncDirtyEntities = false;
    private static final long DIZINIT = 1132241379300L;
    private int ucount = (int)(System.currentTimeMillis() - 1132241379300L) / 100;
    protected HashMap txlist = new HashMap();

    public JHome getHome() {
        return this.home;
    }

    public JLocalHome getLocalHome() {
        return this.localhome;
    }

    public int getLockPolicy() {
        return this.lockPolicy;
    }

    public boolean isPrefetch() {
        return this.prefetch;
    }

    public boolean isCMP2() {
        return this.cmp2;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public boolean getSelectForUpdate() {
        return this.shared && this.lockPolicy == 6;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(int i) {
        this.inactivityTimeout = i;
    }

    public int getDeadlockTimeout() {
        return this.deadlockTimeout;
    }

    public void setDeadlockTimeout(int i) {
        this.deadlockTimeout = i;
    }

    public int getPassivationTimeout() {
        return this.passivationTimeout;
    }

    public void setPassivationTimeout(int i) {
        TraceEjb.logger.log(BasicLevel.WARN, (Object)this.ejbname);
        this.passivationTimeout = i;
    }

    public Object getDataSource() {
        if (this.datasource == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + ": datasource not defined"));
        }
        return this.datasource;
    }

    public void dummyFinderException(boolean dummy) throws FinderException {
        if (!dummy) {
            throw new FinderException("dummy exception !!!");
        }
    }

    public JEntityFactory() {
        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
    }

    private void setDataSource() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cont.getClassLoader());
            InitialContext ictx = this.naming.getInitialContext();
            this.datasource = ictx.lookup(this.dsname);
            TraceEjb.logger.log(BasicLevel.DEBUG, (Object)("DataSource is " + this.datasource));
        }
        catch (NamingException e) {
            String err = this.dsname + " is not known by the EJB server.";
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new EJBException(err, (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void init(EntityDesc dd, JContainer cont) {
        Object[] pobj;
        Class[] ptype;
        int nbp;
        super.init((BeanDesc)dd, cont);
        this.reentrant = dd.isReentrant();
        this.shared = dd.isShared();
        this.lockPolicy = dd.getLockPolicy();
        this.prefetch = dd.isPrefetch();
        this.hardLimit = dd.isHardLimit();
        switch (this.lockPolicy) {
            case 0: {
                if (this.prefetch) {
                    this.prefetch = false;
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"prefetch flag forced to false, with CRU lock policy");
                }
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"This policy (CRU) is deprecated. Use CRW instead!");
                break;
            }
            case 5: {
                if (this.prefetch) {
                    this.prefetch = false;
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)"prefetch flag forced to false with CRW lock policy");
                }
                if (!this.shared) break;
                this.shared = false;
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"shared flag forced to false with CRW lock policy");
                break;
            }
            case 1: {
                if (!this.shared) break;
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"shared flag should be set to false with CS policy");
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"Consider switching to the new CST policy");
                break;
            }
            case 3: {
                if (this.shared) break;
                this.shared = true;
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"shared flag forced to true with DB policy");
            }
        }
        this.inactivityTimeout = dd.getInactivityTimeout();
        this.passivationTimeout = dd.getPassivationTimeout();
        this.deadlockTimeout = dd.getDeadlockTimeout();
        this.readTimeout = dd.getReadTimeout();
        this.setMaxWaitTime(dd.getMaxWaitTime());
        if (dd instanceof EntityJdbcCmp1Desc) {
            this.cmp2 = false;
            this.dsname = ((EntityJdbcCmp1Desc)dd).getDatasourceJndiName();
            if (this.dsname != null) {
                this.setDataSource();
            }
            if (this.lockPolicy == 5) {
                throw new EJBException("Cannot use CONTAINER_READ_WRITE with a CMP1 bean");
            }
        }
        if (dd instanceof EntityJdbcCmp2Desc) {
            this.cmp2 = true;
            this.dsname = ((EntityJdbcCmp2Desc)dd).getDatasourceJndiName();
            if (this.dsname != null) {
                this.setDataSource();
            }
        }
        Class<?> homeclass = null;
        String clname = dd.getFullWrpHomeName();
        if (clname != null) {
            try {
                homeclass = cont.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException e) {
                throw new EJBException(this.ejbname + "Cannot load " + clname, (Exception)e);
            }
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": " + clname + " loaded"));
            }
            try {
                nbp = 2;
                ptype = new Class[nbp];
                pobj = new Object[nbp];
                ptype[0] = EntityDesc.class;
                pobj[0] = dd;
                ptype[1] = JEntityFactory.class;
                pobj[1] = this;
                this.home = (JEntityHome)homeclass.getConstructor(ptype).newInstance(pobj);
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot create home ", e);
            }
            try {
                this.home.register();
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot register home ", e);
            }
        }
        if ((clname = dd.getFullWrpLocalHomeName()) != null) {
            try {
                homeclass = cont.getClassLoader().loadClass(clname);
            }
            catch (ClassNotFoundException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot load " + clname));
                throw new EJBException("Cannot load " + clname, (Exception)e);
            }
            if (TraceEjb.isDebugIc()) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": " + clname + " loaded"));
            }
            try {
                nbp = 2;
                ptype = new Class[nbp];
                pobj = new Object[nbp];
                ptype[0] = EntityDesc.class;
                pobj[0] = dd;
                ptype[1] = JEntityFactory.class;
                pobj[1] = this;
                this.localhome = (JEntityLocalHome)homeclass.getConstructor(ptype).newInstance(pobj);
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot create localhome ", e);
            }
            try {
                this.localhome.register();
            }
            catch (Exception e) {
                throw new EJBException(this.ejbname + " Cannot register localhome ", e);
            }
        }
    }

    public void stop() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        try {
            if (this.home != null) {
                this.home.unregister();
            }
            if (this.localhome != null) {
                this.localhome.unregister();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.stopContainer();
    }

    public int getPoolSize() {
        return this.bctxlist.size();
    }

    public int getCacheSize() {
        return this.instanceCount;
    }

    public boolean tooManyInstances() {
        return this.maxCacheSize > 0 && this.instanceCount >= this.maxCacheSize;
    }

    public boolean isHardLimit() {
        return this.hardLimit;
    }

    public int getCurrentWaiters() {
        return this.currentWaiters;
    }

    public int getMaxWaitTime() {
        return (int)(this.waiterTimeout / 1000L);
    }

    public void setMaxWaitTime(int sec) {
        this.waiterTimeout = (long)sec * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initInstancePool() {
        Context bnctx = this.setComponentContext();
        for (int i = 0; i < this.minPoolSize; ++i) {
            JEntityContext ctx = null;
            try {
                ctx = this.createNewInstance(null);
                List list = this.bctxlist;
                synchronized (list) {
                    this.bctxlist.add(ctx);
                    ++this.instanceCount;
                    continue;
                }
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ejbname + " cannot create new instance"), (Throwable)e);
                break;
            }
        }
        this.resetComponentContext(bnctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JEntityContext getJContext(JEntitySwitch es) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        JEntityContext bctx = null;
        int limit = this.maxCacheSize - this.maxCacheSize / 15;
        if (this.instanceCount >= limit && limit > this.minPoolSize && (this.instanceCount > this.maxCacheSize + limit || this.instanceCount == limit || this.instanceCount == this.maxCacheSize)) {
            if (TraceEjb.isDebugSwapper()) {
                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.ejbname + ": Too many instances :" + this.instanceCount + ", max=" + this.maxCacheSize));
            }
            this.cont.registerBF(this);
        }
        long timetowait = this.waiterTimeout;
        long starttime = 0L;
        List list = this.bctxlist;
        synchronized (list) {
            while (bctx == null) {
                if (this.bctxlist.isEmpty()) {
                    if (!this.hardLimit || !this.tooManyInstances()) {
                        ++this.instanceCount;
                        break;
                    }
                    if (timetowait > 0L) {
                        ++this.currentWaiters;
                        if (starttime == 0L) {
                            starttime = System.currentTimeMillis();
                            if (TraceEjb.isDebugSwapper()) {
                                TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)("WAITING " + this.ejbname));
                            }
                        }
                        try {
                            this.bctxlist.wait(timetowait);
                        }
                        catch (InterruptedException e) {
                            TraceEjb.swapper.log(BasicLevel.WARN, (Object)("INTERRUPTED " + this.ejbname));
                        }
                        finally {
                            --this.currentWaiters;
                        }
                        long stoptime = System.currentTimeMillis();
                        long stillwaited = stoptime - starttime;
                        timetowait = this.waiterTimeout - stillwaited;
                        continue;
                    }
                    TraceEjb.swapper.log(BasicLevel.ERROR, (Object)("max-cache-size reached on " + this.ejbname));
                    throw new EJBException("max-cache-size reached on " + this.ejbname);
                }
                bctx = (JEntityContext)this.bctxlist.remove(0);
            }
        }
        if (bctx == null) {
            try {
                bctx = this.createNewInstance(es);
            }
            catch (Exception e) {
                --this.instanceCount;
                throw new EJBException("Cannot create a new instance ", e);
            }
        }
        return bctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseJContext(JContext ctx, int poolaction) {
        TraceEjb.context.log(BasicLevel.DEBUG, (Object)this.ejbname);
        JEntityContext bctx = (JEntityContext)ctx;
        bctx.razEntityContext();
        boolean poolit = true;
        List list = this.bctxlist;
        synchronized (list) {
            switch (poolaction) {
                case 0: {
                    poolit = false;
                    break;
                }
                case 1: {
                    poolit = this.bctxlist.size() < this.minPoolSize;
                    break;
                }
                default: {
                    boolean bl = poolit = !this.tooManyInstances();
                }
            }
            if (poolit) {
                this.bctxlist.add(bctx);
            } else {
                --this.instanceCount;
            }
            if (this.currentWaiters > 0) {
                this.bctxlist.notify();
            }
        }
    }

    public void releaseJContext(JContext ctx) {
        this.releaseJContext(ctx, 2);
    }

    protected JEntityContext createNewContext(EntityBean bean) {
        return new JEntityContext(this, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JEntityContext createNewInstance(JEntitySwitch es) throws Exception {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        EntityBean bean = null;
        try {
            bean = (EntityBean)this.beanclass.newInstance();
        }
        catch (Exception e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot instantiate bean " + this.instanceCount));
            throw e;
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.myClassLoader());
            JEntityContext ec = this.createNewContext(bean);
            if (es != null) {
                ec.setEntitySwitch(es);
            } else {
                TraceEjb.logger.log(BasicLevel.DEBUG, (Object)"possible error in setEntityContext: No e.s. defined yet");
            }
            bean.setEntityContext((EntityContext)ec);
            ec.setPassive();
            JEntityContext jEntityContext = ec;
            return jEntityContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncDirty(boolean alwaysStore) {
        if (!this.mustSyncDirtyEntities) {
            return;
        }
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.ejbname + " cacheSize = " + this.getCacheSize()));
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.ejbname + " dirtyList size = " + this.dirtyList.size()));
        }
        Context bnctx = this.setComponentContext();
        LinkedList<JEntitySwitch> wsdone = new LinkedList<JEntitySwitch>();
        JEntityFactory jEntityFactory = this;
        synchronized (jEntityFactory) {
            ListIterator i = this.dirtyList.listIterator(0);
            while (i.hasNext()) {
                JEntitySwitch es = (JEntitySwitch)i.next();
                switch (es.passivateIH(alwaysStore, false)) {
                    case 0: {
                        i.remove();
                        break;
                    }
                    case 1: {
                        i.remove();
                        wsdone.addLast(es);
                        break;
                    }
                    case 2: {
                        if (!TraceEjb.isDebugSwapper()) break;
                        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)(this.ejbname + " busy"));
                    }
                }
            }
        }
        this.mustSyncDirtyEntities = false;
        ListIterator i = wsdone.listIterator(0);
        while (i.hasNext()) {
            JEntitySwitch es = (JEntitySwitch)i.next();
            es.endIH();
        }
        this.resetComponentContext(bnctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceCache() {
        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        HashMap clone = null;
        JEntityFactory jEntityFactory = this;
        synchronized (jEntityFactory) {
            clone = (HashMap)this.pklist.clone();
        }
        if (clone.size() == 0) {
            return;
        }
        TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.myClassLoader());
            Context bnctx = this.setComponentContext();
            JEntitySwitch bs2 = null;
            for (JEntitySwitch bs2 : clone.values()) {
                if (bs2.isInFindByPK()) continue;
                bs2.passivateIH(true, true);
            }
            this.resetComponentContext(bnctx);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public boolean dirtyInstances() {
        return this.mustSyncDirtyEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateAutomaticPk() {
        int uid;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        JEntityFactory jEntityFactory = this;
        synchronized (jEntityFactory) {
            uid = this.ucount++;
        }
        return uid;
    }

    public Serializable encodePK(Serializable pk) {
        return pk;
    }

    public Serializable decodePK(Serializable strpk) {
        return strpk;
    }

    public synchronized JEntitySwitch getEJB(Object pk) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return null;
        }
        JEntitySwitch bs = (JEntitySwitch)this.pklist.get(pk);
        while (bs != null && bs.isInFindByPK()) {
            try {
                this.wait(6000L);
            }
            catch (InterruptedException e) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"finder too long");
                break;
            }
            bs = (JEntitySwitch)this.pklist.get(pk);
        }
        if (bs == null) {
            bs = this.getJEntitySwitch();
            bs.init(this, pk);
            this.pklist.put(pk, bs);
        }
        return bs;
    }

    public synchronized JEntitySwitch existEJB(Object pk, JEntitySwitch bs, boolean findbypk) {
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return null;
        }
        JEntitySwitch ret = (JEntitySwitch)this.pklist.get(pk);
        while (ret != null && ret.isInFindByPK()) {
            try {
                this.wait(6000L);
            }
            catch (InterruptedException e) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)"finder too long");
                break;
            }
            ret = (JEntitySwitch)this.pklist.get(pk);
        }
        if (ret == null && bs != null) {
            bs.init(this, pk);
            this.pklist.put(pk, bs);
            if (findbypk) {
                bs.setInFindByPK(true);
            }
        }
        return ret;
    }

    public synchronized void startEJB(Object pk) {
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return;
        }
        JEntitySwitch bs = (JEntitySwitch)this.pklist.get(pk);
        bs.setInFindByPK(false);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rebindEJB(Transaction tx, JEntityContext bctx, Object pk) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return false;
        }
        JEntitySwitch bs = bctx.getEntitySwitch();
        JEntitySwitch old = null;
        JEntityFactory jEntityFactory = this;
        synchronized (jEntityFactory) {
            old = (JEntitySwitch)this.pklist.get(pk);
        }
        boolean ret = true;
        if (old != null) {
            ret = old.terminate(tx);
        }
        JEntityFactory jEntityFactory2 = this;
        synchronized (jEntityFactory2) {
            bs.init(this, pk);
            this.pklist.put(pk, bs);
            this.notifyAll();
        }
        return ret;
    }

    public synchronized void bindEJB(Object pk, JEntitySwitch bs) {
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return;
        }
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        bs.init(this, pk);
        this.pklist.put(pk, bs);
        this.notifyAll();
    }

    public JEntitySwitch getJEntitySwitch() {
        switch (this.lockPolicy) {
            case 0: {
                return new JEntitySwitchCRU();
            }
            case 2: {
                return new JEntitySwitchCRC();
            }
            case 3: {
                return new JEntitySwitchDB();
            }
            case 4: {
                return new JEntitySwitchRO();
            }
            case 5: {
                return new JEntitySwitchCRW();
            }
            case 6: {
                return new JEntitySwitchCST();
            }
            case 1: {
                return new JEntitySwitchCS();
            }
        }
        TraceEjb.logger.log(BasicLevel.WARN, (Object)"lockPolicy not initilized");
        return new JEntitySwitchCS();
    }

    public synchronized void removeEJB(Object pk) {
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if (pk == null) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"pk null ???");
            return;
        }
        this.pklist.remove(pk);
        this.notifyAll();
    }

    public synchronized void registerEJB(JEntitySwitch ejb) {
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if (this.dirtyList.contains(ejb)) {
            TraceEjb.swapper.log(BasicLevel.ERROR, (Object)(this.ejbname + " Elt already in the dirty list"));
            return;
        }
        this.dirtyList.addLast(ejb);
        this.mustSyncDirtyEntities = true;
    }

    public void synchronizeEntities() {
        if (TraceEjb.isDebugSwapper()) {
            TraceEjb.swapper.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        this.cont.registerBFS(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeadLocked(Transaction suspect) {
        HashMap clone = null;
        JEntityFactory jEntityFactory = this;
        synchronized (jEntityFactory) {
            clone = (HashMap)this.pklist.clone();
        }
        JEntitySwitch es2 = null;
        ArrayList<Transaction> blktx = new ArrayList<Transaction>();
        Transaction testedtx = suspect;
        while (true) {
            for (JEntitySwitch es2 : clone.values()) {
                Transaction tx = es2.getBlockingTx(testedtx);
                if (tx == null) continue;
                if (tx.equals(suspect)) {
                    TraceEjb.synchro.log(BasicLevel.WARN, (Object)("Found a deadlock on :" + tx));
                    return true;
                }
                blktx.add(tx);
            }
            if (blktx.size() == 0) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)"No deadlock found");
                return false;
            }
            testedtx = (Transaction)blktx.remove(0);
        }
    }

    public synchronized EntityCounters getEntityCounters() {
        EntityCounters ec = new EntityCounters();
        Collection coll = this.pklist.values();
        ec.pk = this.pklist.size();
        for (JEntitySwitch es : coll) {
            switch (es.getState()) {
                case 0: {
                    ++ec.inTx;
                    break;
                }
                case 1: {
                    ++ec.outTx;
                    break;
                }
                case 2: {
                    ++ec.idle;
                    break;
                }
                case 3: {
                    ++ec.passive;
                    break;
                }
                case 4: {
                    ++ec.removed;
                }
            }
        }
        return ec;
    }

    public void syncForFind(Transaction tx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if (tx == null) {
            if (this.lockPolicy == 1) {
                this.syncDirty(true);
            }
        } else {
            this.getContainer().storeAll(tx);
        }
    }

    public void syncForSelect() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        Transaction currtx = null;
        try {
            currtx = this.tm.getTransaction();
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("currtx=" + currtx));
            }
        }
        catch (SystemException e) {
            TraceEjb.logger.log(BasicLevel.ERROR, (Object)"system exception while getting transaction:", (Throwable)e);
            return;
        }
        this.syncForFind(currtx);
    }

    public void storeInstances(Transaction tx) {
        TxListener txl = (TxListener)this.txlist.get(tx);
        if (txl != null) {
            txl.storeInstances();
        }
    }

    public void removeTxListener(Transaction tx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        this.txlist.remove(tx);
    }

    public void unregisterContext(Transaction tx, JEntityContext ec) throws IllegalStateException {
        TxListener txl;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if ((txl = (TxListener)this.txlist.get(tx)) == null) {
            return;
        }
        txl.removeInstance(ec);
    }

    public boolean registerContext(Transaction tx, JEntityContext ec) throws IllegalStateException {
        TxListener txl;
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)this.ejbname);
        }
        if ((txl = (TxListener)this.txlist.get(tx)) == null) {
            txl = new TxListener(this, tx);
            try {
                tx.registerSynchronization((Synchronization)txl);
            }
            catch (RollbackException e) {
                if (TraceEjb.isVerbose()) {
                    TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ejbname + " transaction has been marked rollbackOnly"), (Throwable)e);
                }
                return false;
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ejbname + " cannot register synchro "), (Throwable)e);
                throw new IllegalStateException("cannot register synchro");
            }
            this.txlist.put(tx, txl);
        }
        txl.addInstance(ec);
        return true;
    }

    public void checkTransaction(RequestCtx rctx) {
        this.checkTransactionContainer(rctx);
    }

    public TimerService getTimerService() {
        return this;
    }

    public Timer createTimer(long arg0, Serializable arg1) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException("timers are associated with a PK");
    }

    public Timer createTimer(long arg0, long arg1, Serializable arg2) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException("timers are associated with a PK");
    }

    public Timer createTimer(Date arg0, Serializable arg1) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException("timers are associated with a PK");
    }

    public Timer createTimer(Date arg0, long arg1, Serializable arg2) throws IllegalArgumentException, IllegalStateException, EJBException {
        throw new IllegalStateException("timers are associated with a PK");
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        throw new IllegalStateException("timers are associated with a PK");
    }
}

