/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DataReadQuery
extends ReadQuery {
    protected ContainerPolicy containerPolicy;
    protected int resultType;
    public static final int MAP = 0;
    public static final int ARRAY = 1;
    public static final int VALUE = 2;
    public static final int ATTRIBUTE = 3;
    public static final int AUTO = 4;

    public DataReadQuery() {
        this.shouldMaintainCache = false;
        this.resultType = 0;
        this.setContainerPolicy(ContainerPolicy.buildDefaultPolicy());
    }

    public DataReadQuery(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    public DataReadQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void cacheResult(Object results) {
        this.setTemporaryCachedQueryResults(results);
    }

    public Object clone() {
        DataReadQuery cloneQuery = (DataReadQuery)super.clone();
        cloneQuery.setContainerPolicy(this.getContainerPolicy().clone(cloneQuery));
        return cloneQuery;
    }

    public Object execute(AbstractSession session, AbstractRecord row) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.containerPolicy.overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.isPrepared) {
                Object results = this.getQueryResults(session, row, true);
                if (results == InvalidObject.instance) {
                    if (this.resultType == 2) {
                        return null;
                    }
                    return this.containerPolicy.containerInstance(0);
                }
                if (results != null) {
                    return results;
                }
            }
        }
        return super.execute(session, row);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        return this.executeNonCursor();
    }

    public Converter getValueConverter() {
        return null;
    }

    public Object buildObject(AbstractRecord row) {
        if (this.resultType == 4) {
            Vector values = row.getValues();
            if (values.size() == 1) {
                return row.getValues().get(0);
            }
            return row.getValues().toArray();
        }
        if (this.resultType == 1) {
            return row.getValues().toArray();
        }
        if (this.resultType == 3) {
            Object value = row.get(row.getFields().get(0));
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertDataValueToObjectValue(value, this.session);
            }
            return value;
        }
        return row;
    }

    protected Object executeNonCursor() throws DatabaseException {
        Object results;
        block6: {
            Vector rows;
            block5: {
                rows = this.getQueryMechanism().executeSelect();
                results = null;
                if (this.resultType != 2) break block5;
                if (rows.isEmpty()) break block6;
                AbstractRecord record = (AbstractRecord)rows.get(0);
                results = record.get(record.getFields().get(0));
                if (this.getValueConverter() == null) break block6;
                results = this.getValueConverter().convertDataValueToObjectValue(results, this.session);
                break block6;
            }
            int size = rows.size();
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            results = containerPolicy.containerInstance(size);
            if (containerPolicy.shouldAddAll()) {
                if (size > 0) {
                    ArrayList<Object> values = new ArrayList<Object>(size);
                    for (int index = 0; index < size; ++index) {
                        AbstractRecord row = (AbstractRecord)rows.get(index);
                        Object value = this.buildObject(row);
                        values.add(value);
                    }
                    containerPolicy.addAll(values, results, this.session, (List<AbstractRecord>)rows, this);
                }
            } else {
                for (int index = 0; index < size; ++index) {
                    AbstractRecord row = (AbstractRecord)rows.get(index);
                    Object value = this.buildObject(row);
                    containerPolicy.addInto(value, results, this.session, row, this);
                }
            }
        }
        this.cacheResult(results);
        return results;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public boolean isDataReadQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        return super.remoteExecute();
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public void setResultType(String resultType) {
        if ("Map".equals(resultType)) {
            this.resultType = 0;
        } else if ("Array".equals(resultType)) {
            this.resultType = 1;
        } else if ("Value".equals(resultType)) {
            this.resultType = 2;
        } else if ("Attribute".equals(resultType)) {
            this.resultType = 3;
        }
    }

    public void useCursoredStream(int initialReadSize, int pageSize) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize));
    }

    public void useCursoredStream(int initialReadSize, int pageSize, ValueReadQuery sizeQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, initialReadSize, pageSize, sizeQuery));
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int pageSize) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, pageSize));
    }

    public void useScrollableCursor(ScrollableCursorPolicy policy) {
        policy.setQuery(this);
        this.setContainerPolicy(policy);
    }
}

