/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced;

import java.util.concurrent.Executor;
import org.ow2.util.pool.impl.enhanced.EnhancedCluePool;
import org.ow2.util.pool.impl.enhanced.ResizerType;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.thread.ThreadPool;
import org.ow2.util.pool.impl.enhanced.impl.util.ExecutorProvider;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared.SharedResizerPoolThreadManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.ICluePoolManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedCluePoolFactory {
    private IPool<IReusableThread> pool;

    public EnhancedCluePoolFactory(IPool<IReusableThread> pool) {
        this.pool = pool;
    }

    public <E, C> EnhancedCluePool<E, C> createEnhancedCluePool(ICluePoolManager<E, C> cluePoolManager) {
        return this.createEnhancedCluePool(cluePoolManager, false, true);
    }

    public <E, C> EnhancedCluePool<E, C> createEnhancedCluePool(ICluePoolManager<E, C> cluePoolManager, boolean setSizeShared, boolean schedulerShared) {
        Executor executor = schedulerShared ? new ThreadPool(this.pool, 0L) : ExecutorProvider.SELF_THREAD_EXECUTOR;
        if (setSizeShared) {
            return new EnhancedCluePool<E, C>(cluePoolManager, ResizerType.SHARED_ASYNCHRONOUS, new SharedResizerPoolThreadManager(this.pool), executor);
        }
        return new EnhancedCluePool<E, C>(cluePoolManager, ResizerType.SIMPLE, null, executor);
    }
}

