/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class NullIfExpression
extends AbstractVal {
    private final Val _val1;
    private final Val _val2;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private Value other = null;
    private ExpState otherState = null;

    public NullIfExpression(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    public Val getVal1() {
        return this._val1;
    }

    public Val getVal2() {
        return this._val2;
    }

    public Class getType() {
        Class c2;
        if (this._cast != null) {
            return this._cast;
        }
        Class c1 = this._val1.getType();
        Class<?> type = Filters.promote(c1, c2 = this._val2.getType());
        if (type == Raw.class) {
            return String.class;
        }
        return type;
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState s1 = this._val1.initialize(sel, ctx, 0);
        ExpState s2 = this._val2.initialize(sel, ctx, 0);
        return new BinaryOpExpState(sel.and(s1.joins, s2.joins), s1, s2);
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf, int index) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        buf.append(" NULLIF(");
        this._val1.appendTo(sel, ctx, bstate.state1, buf, 0);
        buf.append(",");
        this._val2.appendTo(sel, ctx, bstate.state2, buf, 0);
        buf.append(")");
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.selectColumns(sel, ctx, bstate.state1, true);
        this._val2.selectColumns(sel, ctx, bstate.state2, true);
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit(this);
    }

    public int getId() {
        return 18;
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.calculateValue(sel, ctx, bstate.state1, this._val2, bstate.state2);
        this._val2.calculateValue(sel, ctx, bstate.state2, this._val1, bstate.state1);
    }

    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert(res.getObject(this, 1012, null), this.getType());
    }

    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public void setOtherPath(Value other) {
        this.other = other;
    }

    public Value getOtherPath() {
        return this.other;
    }

    public void setOtherState(ExpState otherState) {
        this.otherState = otherState;
    }

    public ExpState getOtherState() {
        return this.otherState;
    }
}

