/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.EJBLocalObject;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.type.lib.PTypeSpaceMedor;
import org.ow2.jonas.lib.ejb21.jorm.FloatPkFieldMapping;

public class JormType {
    public static PType getPType(Class cl, boolean isPkField) {
        if (cl.equals(Boolean.TYPE)) {
            return PTypeSpace.BOOLEAN;
        }
        if (cl.equals(Boolean.class)) {
            return PTypeSpace.OBJBOOLEAN;
        }
        if (cl.equals(Character.TYPE)) {
            return PTypeSpace.CHAR;
        }
        if (cl.equals(Character.class)) {
            return PTypeSpace.OBJCHAR;
        }
        if (cl.equals(Byte.TYPE)) {
            return PTypeSpace.BYTE;
        }
        if (cl.equals(Byte.class)) {
            return PTypeSpace.OBJBYTE;
        }
        if (cl.equals(Short.TYPE)) {
            return PTypeSpace.SHORT;
        }
        if (cl.equals(Short.class)) {
            return PTypeSpace.OBJSHORT;
        }
        if (cl.equals(Integer.TYPE)) {
            return PTypeSpace.INT;
        }
        if (cl.equals(Integer.class)) {
            return PTypeSpace.OBJINT;
        }
        if (cl.equals(Long.TYPE)) {
            return PTypeSpace.LONG;
        }
        if (cl.equals(Long.class)) {
            return PTypeSpace.OBJLONG;
        }
        if (cl.equals(Float.TYPE)) {
            return PTypeSpace.FLOAT;
        }
        if (cl.equals(Float.class)) {
            if (isPkField) {
                return JormType.getPType(FloatPkFieldMapping.getStorageType(), false);
            }
            return PTypeSpace.OBJFLOAT;
        }
        if (cl.equals(Double.TYPE)) {
            return PTypeSpace.DOUBLE;
        }
        if (cl.equals(Double.class)) {
            return PTypeSpace.OBJDOUBLE;
        }
        if (cl.equals(String.class)) {
            return PTypeSpace.STRING;
        }
        if (cl.equals(Date.class) || cl.equals(java.sql.Date.class) || cl.equals(Time.class) || cl.equals(Timestamp.class)) {
            return PTypeSpace.DATE;
        }
        if (cl.equals(BigDecimal.class)) {
            return PTypeSpace.BIGDECIMAL;
        }
        if (EJBLocalObject.class.isAssignableFrom(cl)) {
            return PTypeSpaceMedor.PNAME;
        }
        if (cl.isArray() && Byte.TYPE.equals(cl.getComponentType())) {
            return PTypeSpace.BYTEARRAY;
        }
        if (cl.isArray() && Character.TYPE.equals(cl.getComponentType())) {
            return PTypeSpace.CHARARRAY;
        }
        return PTypeSpace.SERIALIZED;
    }

    public static String getPTypeDef(Class cl, boolean isPkField) {
        if (cl.equals(Boolean.TYPE)) {
            return "PTypeSpace.BOOLEAN";
        }
        if (cl.equals(Boolean.class)) {
            return "PTypeSpace.OBJBOOLEAN";
        }
        if (cl.equals(String.class)) {
            return "PTypeSpace.STRING";
        }
        if (cl.equals(Character.TYPE)) {
            return "PTypeSpace.CHAR";
        }
        if (cl.equals(Character.class)) {
            return "PTypeSpace.OBJCHAR";
        }
        if (cl.equals(Byte.TYPE)) {
            return "PTypeSpace.BYTE";
        }
        if (cl.equals(Byte.class)) {
            return "PTypeSpace.OBJBYTE";
        }
        if (cl.equals(Short.TYPE)) {
            return "PTypeSpace.SHORT";
        }
        if (cl.equals(Short.class)) {
            return "PTypeSpace.OBJSHORT";
        }
        if (cl.equals(Integer.TYPE)) {
            return "PTypeSpace.INT";
        }
        if (cl.equals(Integer.class)) {
            return "PTypeSpace.OBJINT";
        }
        if (cl.equals(Long.TYPE)) {
            return "PTypeSpace.LONG";
        }
        if (cl.equals(Long.class)) {
            return "PTypeSpace.OBJLONG";
        }
        if (cl.equals(Float.TYPE)) {
            return "PTypeSpace.FLOAT";
        }
        if (cl.equals(Float.class)) {
            if (isPkField) {
                return JormType.getPTypeDef(FloatPkFieldMapping.getStorageType(), false);
            }
            return "PTypeSpace.OBJFLOAT";
        }
        if (cl.equals(Double.TYPE)) {
            return "PTypeSpace.DOUBLE";
        }
        if (cl.equals(Double.class)) {
            return "PTypeSpace.OBJDOUBLE";
        }
        if (cl.equals(Date.class) || cl.equals(java.sql.Date.class) || cl.equals(Time.class) || cl.equals(Timestamp.class)) {
            return "PTypeSpace.DATE";
        }
        if (cl.equals(BigDecimal.class)) {
            return "PTypeSpace.BIGDECIMAL";
        }
        if (EJBLocalObject.class.isAssignableFrom(cl)) {
            return "PTypeSpaceMedor.PNAME";
        }
        if (cl.isArray() && Byte.TYPE.equals(cl.getComponentType())) {
            return "PTypeSpace.BYTEARRAY";
        }
        if (cl.isArray() && Character.TYPE.equals(cl.getComponentType())) {
            return "PTypeSpace.CHARARRAY";
        }
        return "PTypeSpace.SERIALIZED";
    }

    public static short getCodingType(Class c, boolean isPkField) throws PExceptionNaming {
        if (c == null) {
            throw new PExceptionNaming("No CodingType associated to a null Class");
        }
        return JormType.getCodingType(JormType.getPType(c, isPkField).getTypeCode());
    }

    public static short getCodingType(PType pt) throws PExceptionNaming {
        if (pt == null) {
            throw new PExceptionNaming("No CodingType associated to a null PType");
        }
        return JormType.getCodingType(pt.getTypeCode());
    }

    public static short getCodingType(int typeCode) throws PExceptionNaming {
        switch (typeCode) {
            case 1: {
                return 2;
            }
            case 9: {
                return 64;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 32;
            }
            case 3: {
                return 4;
            }
            case 11: {
                return 128;
            }
            case 4: {
                return 8;
            }
            case 12: {
                return 256;
            }
            case 5: {
                return 16;
            }
            case 13: {
                return 512;
            }
            case 19: {
                return 8192;
            }
            case 18: {
                return 4096;
            }
            case 16: {
                return 1024;
            }
            case 17: {
                return 2048;
            }
        }
        throw new PExceptionNaming("This type is not suportted: typeCode=" + typeCode);
    }
}

