/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.DestinationMBean;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.TemporaryQueue;
import org.objectweb.joram.client.jms.TemporaryTopic;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.admin.XmlSerializer;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.admin.AdminCommandReply;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.DeleteDestination;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetRightsReply;
import org.objectweb.joram.shared.admin.GetRightsRequest;
import org.objectweb.joram.shared.admin.GetStatsReply;
import org.objectweb.joram.shared.admin.GetStatsRequest;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.admin.UnsetReader;
import org.objectweb.joram.shared.admin.UnsetWriter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Destination
extends AdministeredObject
implements javax.jms.Destination,
DestinationMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)Destination.class.getName());
    protected String agentId;
    public static final byte TOPIC_TYPE = 1;
    public static final byte QUEUE_TYPE = 2;
    public static final byte TEMPORARY = 16;
    private byte type;
    protected String adminName;
    AdminWrapper wrapper = null;
    public static final String QUEUE = "org.objectweb.joram.mom.dest.Queue";
    public static final String TOPIC = "org.objectweb.joram.mom.dest.Topic";
    public static final String DEAD_MQUEUE = "org.objectweb.joram.mom.dest.Queue";
    public static final String CLUSTER_QUEUE = "org.objectweb.joram.mom.dest.ClusterQueue";
    public static final String SCHEDULER_QUEUE = "com.scalagent.joram.mom.dest.scheduler.SchedulerQueue";
    public static final String ACQUISITION_QUEUE = "org.objectweb.joram.mom.dest.AcquisitionQueue";
    public static final String DISTRIBUTION_QUEUE = "org.objectweb.joram.mom.dest.DistributionQueue";
    public static final String ACQUISITION_TOPIC = "org.objectweb.joram.mom.dest.AcquisitionTopic";
    public static final String DISTRIBUTION_TOPIC = "org.objectweb.joram.mom.dest.DistributionTopic";
    protected transient String JMXBeanName = null;

    public String getName() {
        return this.agentId;
    }

    public static final void checkId(String id) throws InvalidDestinationException {
        try {
            DestinationConstants.checkId((String)id);
        }
        catch (Exception exc) {
            throw new InvalidDestinationException(exc.getMessage());
        }
    }

    public void check() throws InvalidDestinationException {
        Destination.checkId(this.getName());
    }

    public byte getType() {
        return this.type;
    }

    public final String getAdminName() {
        return this.adminName;
    }

    public Destination() {
    }

    protected Destination(byte type) {
        this.type = type;
    }

    protected Destination(String id, byte type) {
        this.agentId = id;
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Destination)) {
            return false;
        }
        return this.getName().equals(((Destination)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected final AdminWrapper getWrapper() throws ConnectException {
        if (this.wrapper != null && !this.wrapper.isClosed()) {
            return this.wrapper;
        }
        return AdminModule.getWrapper();
    }

    public void setWrapper(AdminWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public final AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        return this.getWrapper().doRequest(request);
    }

    public String toXml(int indent, int serverId) throws ConnectException, AdminException {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(XmlSerializer.indent(indent));
        if (this.getType() == 2) {
            strbuf.append("<Queue ");
        } else if (this.getType() == 1) {
            strbuf.append("<Topic ");
        } else {
            return "";
        }
        strbuf.append(XmlSerializer.xmlAttribute(this.getAdminName(), "name"));
        strbuf.append(XmlSerializer.xmlAttribute(String.valueOf(serverId), "serverId"));
        Queue dmq = this.getDMQ();
        if (dmq != null) {
            strbuf.append(XmlSerializer.xmlAttribute(dmq.getAdminName(), "dmq"));
            strbuf.append(XmlSerializer.xmlAttribute(String.valueOf(dmq.getThreshold()), "threshold"));
        }
        strbuf.append(">\n");
        indent += 2;
        if (this.isFreelyReadable()) {
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<freeReader/>\n");
        }
        if (this.isFreelyWriteable()) {
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<freeWriter/>\n");
        }
        List readers = this.getReaders();
        ListIterator iterator = readers.listIterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<reader ");
            strbuf.append(XmlSerializer.xmlAttribute(user.getName(), "user"));
            strbuf.append("/>\n");
        }
        List writers = this.getWriters();
        ListIterator iterator2 = writers.listIterator();
        while (iterator2.hasNext()) {
            User user = (User)iterator2.next();
            strbuf.append(XmlSerializer.indent(indent));
            strbuf.append("<writer ");
            strbuf.append(XmlSerializer.xmlAttribute(user.getName(), "user"));
            strbuf.append("/>\n");
        }
        strbuf.append(XmlSerializer.indent(indent));
        strbuf.append("<jndi ");
        strbuf.append(XmlSerializer.xmlAttribute(this.getAdminName(), "name"));
        strbuf.append("/>\n");
        strbuf.append(XmlSerializer.indent(indent -= 2));
        if (this.getType() == 2) {
            strbuf.append("</Queue>\n");
        } else if (this.getType() == 1) {
            strbuf.append("</Topic>\n");
        }
        return strbuf.toString();
    }

    public boolean isQueue() {
        return this instanceof javax.jms.Queue;
    }

    public boolean isTopic() {
        return this instanceof javax.jms.Topic;
    }

    protected void doCreate(int serverId, String name, String className, Properties props, Destination dest, byte type) throws ConnectException, AdminException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Destination.doCreate(" + serverId + ',' + name + ',' + className + ',' + props + ',' + dest + ',' + type + ')'));
        }
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, props, type);
        CreateDestinationReply reply = (CreateDestinationReply)this.getWrapper().doRequest((AdminRequest)cdr);
        dest.agentId = reply.getId();
        dest.adminName = name;
    }

    public void delete() throws ConnectException, AdminException, JMSException {
        this.doRequest((AdminRequest)new DeleteDestination(this.getName()));
        this.unregisterMBean();
    }

    public static String getJMXBeanName(String base, Destination dest) {
        String agentId = dest.agentId;
        int sid = Integer.parseInt(agentId.substring(agentId.indexOf(46) + 1, agentId.lastIndexOf(46)));
        StringBuffer buf = new StringBuffer();
        buf.append(base);
        if (dest.isQueue()) {
            buf.append(":type=Queue,location=server#");
        } else {
            buf.append(":type=Topic,location=server#");
        }
        buf.append(sid).append(",name=").append(dest.getAdminName()).append('[').append(dest.getName()).append(']');
        return buf.toString();
    }

    public String registerMBean(String base) {
        block3: {
            if (MXWrapper.mxserver == null) {
                return null;
            }
            this.JMXBeanName = Destination.getJMXBeanName(base, this);
            try {
                MXWrapper.registerMBean((Object)this, (String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("Destination.registerMBean: " + this.JMXBeanName), (Throwable)e);
            }
        }
        return this.JMXBeanName;
    }

    public void unregisterMBean() {
        block3: {
            if (MXWrapper.mxserver == null || this.JMXBeanName == null) {
                return;
            }
            try {
                MXWrapper.unregisterMBean((String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("Destination.unregisterMBean: " + this.JMXBeanName), (Throwable)e);
            }
        }
    }

    public void setFreeReading() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetReader(null, this.getName()));
    }

    public void setFreeWriting() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetWriter(null, this.getName()));
    }

    public void unsetFreeReading() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetReader(null, this.getName()));
    }

    public void unsetFreeWriting() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetWriter(null, this.getName()));
    }

    public void setReader(User user) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetReader(user.getProxyId(), this.getName()));
    }

    public void addReader(String proxyId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetReader(proxyId, this.getName()));
    }

    public void setWriter(User user) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetWriter(user.getProxyId(), this.getName()));
    }

    public void addWriter(String proxyId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetWriter(proxyId, this.getName()));
    }

    public void unsetReader(User user) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetReader(user.getProxyId(), this.getName()));
    }

    public void removeReader(String proxyId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetReader(proxyId, this.getName()));
    }

    public void unsetWriter(User user) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetWriter(user.getProxyId(), this.getName()));
    }

    public void removeWriter(String proxyId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new UnsetWriter(proxyId, this.getName()));
    }

    public List getReaders() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getReaders();
        if (users != null) {
            Enumeration names = users.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                list.add(new User(name, (String)users.get(name)));
            }
        }
        return list;
    }

    public List getReaderList() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        Vector list = new Vector();
        Hashtable users = reply.getReaders();
        if (users != null) {
            Enumeration names = users.keys();
            while (names.hasMoreElements()) {
                list.add(names.nextElement());
            }
        }
        return list;
    }

    public List getWriters() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        Vector<User> list = new Vector<User>();
        Hashtable users = reply.getWriters();
        if (users != null) {
            Enumeration names = users.keys();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                list.add(new User(name, (String)users.get(name)));
            }
        }
        return list;
    }

    public List getWriterList() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        Vector list = new Vector();
        Hashtable users = reply.getWriters();
        if (users != null) {
            Enumeration names = users.keys();
            while (names.hasMoreElements()) {
                list.add(names.nextElement());
            }
        }
        return list;
    }

    public boolean isFreelyReadable() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        return reply.isFreeReading();
    }

    public void setFreelyReadable(boolean b) throws ConnectException, AdminException {
        if (b) {
            this.setFreeReading();
        } else {
            this.unsetFreeReading();
        }
    }

    public boolean isFreelyWriteable() throws ConnectException, AdminException {
        GetRightsRequest request = new GetRightsRequest(this.getName());
        GetRightsReply reply = (GetRightsReply)this.doRequest((AdminRequest)request);
        return reply.isFreeWriting();
    }

    public void setFreelyWriteable(boolean b) throws ConnectException, AdminException {
        if (b) {
            this.setFreeWriting();
        } else {
            this.unsetFreeWriting();
        }
    }

    public Queue getDMQ() throws ConnectException, AdminException {
        String dmqId = this.getDMQId();
        Queue dmq = null;
        if (dmqId != null) {
            dmq = new Queue(dmqId);
            if (this.wrapper != null) {
                dmq.setWrapper(this.wrapper);
            }
        }
        return dmq;
    }

    public String getDMQId() throws ConnectException, AdminException {
        GetDMQSettingsRequest request = new GetDMQSettingsRequest(this.getName());
        GetDMQSettingsReply reply = (GetDMQSettingsReply)this.doRequest((AdminRequest)request);
        return reply.getDMQName();
    }

    public void setDMQ(Queue dmq) throws ConnectException, AdminException, InvalidDestinationException {
        if (dmq != null) {
            this.setDMQId(dmq.getName());
        } else {
            this.setDMQId(null);
        }
    }

    public void setDMQId(String dmqId) throws ConnectException, AdminException, InvalidDestinationException {
        if (dmqId != null) {
            Destination.checkId(dmqId);
        }
        this.doRequest((AdminRequest)new SetDMQRequest(this.getName(), dmqId));
    }

    public static Destination newInstance(String id, String name, byte type) throws AdminException {
        Destination dest;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Destination.newInstance(" + id + ',' + name + ',' + type + ')'));
        }
        if ((type & 2) != 0) {
            dest = (type & 0x10) != 0 ? new TemporaryQueue(id, null) : new Queue(id);
        } else if ((type & 1) != 0) {
            dest = (type & 0x10) != 0 ? new TemporaryTopic(id, null) : new Topic(id);
        } else {
            throw new AdminException("Unknown destination type (" + type + ')');
        }
        dest.adminName = name;
        return dest;
    }

    public Hashtable getStatistic() throws ConnectException, AdminException {
        return this.getStatistics();
    }

    public Hashtable getStatistics() throws ConnectException, AdminException {
        GetStatsRequest request = new GetStatsRequest(this.getName());
        GetStatsReply reply = (GetStatsReply)this.doRequest((AdminRequest)request);
        return reply.getStats();
    }

    public void toReference(Reference ref) throws NamingException {
        ref.add(new StringRefAddr("dest.agentId", this.agentId));
        ref.add(new StringRefAddr("dest.adminName", this.adminName));
    }

    public void fromReference(Reference ref) throws NamingException {
        this.agentId = (String)ref.get("dest.agentId").getContent();
        this.adminName = (String)ref.get("dest.adminName").getContent();
    }

    public Hashtable code() {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put("agentId", this.getName());
        h.put("type", new Byte(this.type));
        return h;
    }

    public void decode(Hashtable h) {
        this.agentId = (String)h.get("agentId");
        this.type = (Byte)h.get("type");
    }

    public void addInterceptors(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors", interceptors);
        this.getWrapper().processAdmin(this.getName(), 1, prop);
    }

    public String getInterceptors() throws ConnectException, AdminException {
        AdminCommandReply reply = (AdminCommandReply)AdminModule.processAdmin(this.getName(), 3, null);
        return (String)reply.getProp().get("jms_joram_interceptors");
    }

    public void removeInterceptors(String interceptors) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors", interceptors);
        AdminModule.processAdmin(this.getName(), 2, prop);
    }

    public void replaceInterceptor(String newInterceptor, String oldInterceptor) throws ConnectException, AdminException {
        Properties prop = new Properties();
        prop.put("jms_joram_interceptors_new", newInterceptor);
        prop.put("jms_joram_interceptors_old", oldInterceptor);
        this.getWrapper().processAdmin(this.getName(), 4, prop);
    }

    public AdminReply setProperties(Properties prop) throws ConnectException, AdminException {
        return this.getWrapper().processAdmin(this.getName(), 5, prop);
    }
}

