/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.StringRefAddr;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextHandler;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ContextTransaction;
import org.apache.catalina.deploy.NamingResources;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextAccessController;
import org.apache.naming.ContextBindings;
import org.apache.naming.EjbRef;
import org.apache.naming.HandlerRef;
import org.apache.naming.NamingContext;
import org.apache.naming.ResourceEnvRef;
import org.apache.naming.ResourceLinkRef;
import org.apache.naming.ResourceRef;
import org.apache.naming.ServiceRef;
import org.apache.naming.TransactionRef;
import org.apache.naming.factory.ResourceLinkFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class NamingContextListener
implements LifecycleListener,
ContainerListener,
PropertyChangeListener {
    private static final Log log = LogFactory.getLog(NamingContextListener.class);
    protected Log logger = log;
    protected String name = "/";
    protected Object container = null;
    protected boolean initialized = false;
    protected NamingResources namingResources = null;
    protected NamingContext namingContext = null;
    protected javax.naming.Context compCtx = null;
    protected javax.naming.Context envCtx = null;
    protected HashMap<String, ObjectName> objectNames = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public javax.naming.Context getCompContext() {
        return this.compCtx;
    }

    public javax.naming.Context getEnvContext() {
        return this.envCtx;
    }

    public NamingContext getNamingContext() {
        return this.namingContext;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        this.container = event.getLifecycle();
        if (this.container instanceof Context) {
            this.namingResources = ((Context)this.container).getNamingResources();
            this.logger = log;
        } else if (this.container instanceof Server) {
            this.namingResources = ((Server)this.container).getGlobalNamingResources();
        } else {
            return;
        }
        if ("configure_start".equals(event.getType())) {
            if (this.initialized) {
                return;
            }
            Hashtable<String, Object> contextEnv = new Hashtable<String, Object>();
            try {
                this.namingContext = new NamingContext(contextEnv, this.getName());
            }
            catch (NamingException e) {
                // empty catch block
            }
            ContextAccessController.setSecurityToken(this.getName(), this.container);
            ContextBindings.bindContext(this.container, this.namingContext, this.container);
            if (log.isDebugEnabled()) {
                log.debug("Bound " + this.container);
            }
            ContextAccessController.setWritable(this.getName(), this.container);
            try {
                this.createNamingContext();
            }
            catch (NamingException e) {
                this.logger.error(sm.getString("naming.namingContextCreationFailed", e));
            }
            this.namingResources.addPropertyChangeListener(this);
            if (this.container instanceof Context) {
                ContextAccessController.setReadOnly(this.getName());
                try {
                    ContextBindings.bindClassLoader(this.container, this.container, ((Container)this.container).getLoader().getClassLoader());
                }
                catch (NamingException e) {
                    this.logger.error(sm.getString("naming.bindFailed", e));
                }
            }
            if (this.container instanceof Server) {
                ResourceLinkFactory.setGlobalContext(this.namingContext);
                try {
                    ContextBindings.bindClassLoader(this.container, this.container, this.getClass().getClassLoader());
                }
                catch (NamingException e) {
                    this.logger.error(sm.getString("naming.bindFailed", e));
                }
                if (this.container instanceof StandardServer) {
                    ((StandardServer)this.container).setGlobalNamingContext(this.namingContext);
                }
            }
            this.initialized = true;
        } else if ("configure_stop".equals(event.getType())) {
            if (!this.initialized) {
                return;
            }
            ContextAccessController.setWritable(this.getName(), this.container);
            ContextBindings.unbindContext(this.container, this.container);
            if (this.container instanceof Context) {
                ContextBindings.unbindClassLoader(this.container, this.container, ((Container)this.container).getLoader().getClassLoader());
            }
            if (this.container instanceof Server) {
                this.namingResources.removePropertyChangeListener(this);
                ContextBindings.unbindClassLoader(this.container, this.container, this.getClass().getClassLoader());
            }
            ContextAccessController.unsetSecurityToken(this.getName(), this.container);
            this.namingContext = null;
            this.envCtx = null;
            this.compCtx = null;
            this.initialized = false;
        }
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        String serviceName;
        if (!this.initialized) {
            return;
        }
        ContextAccessController.setWritable(this.getName(), this.container);
        String type = event.getType();
        if (type.equals("addEjb")) {
            String ejbName = (String)event.getData();
            if (ejbName != null) {
                ContextEjb ejb = this.namingResources.findEjb(ejbName);
                this.addEjb(ejb);
            }
        } else if (type.equals("addEnvironment")) {
            String environmentName = (String)event.getData();
            if (environmentName != null) {
                ContextEnvironment env = this.namingResources.findEnvironment(environmentName);
                this.addEnvironment(env);
            }
        } else if (type.equals("addLocalEjb")) {
            String localEjbName = (String)event.getData();
            if (localEjbName != null) {
                ContextLocalEjb localEjb = this.namingResources.findLocalEjb(localEjbName);
                this.addLocalEjb(localEjb);
            }
        } else if (type.equals("addResource")) {
            String resourceName = (String)event.getData();
            if (resourceName != null) {
                ContextResource resource = this.namingResources.findResource(resourceName);
                this.addResource(resource);
            }
        } else if (type.equals("addResourceLink")) {
            String resourceLinkName = (String)event.getData();
            if (resourceLinkName != null) {
                ContextResourceLink resourceLink = this.namingResources.findResourceLink(resourceLinkName);
                this.addResourceLink(resourceLink);
            }
        } else if (type.equals("addResourceEnvRef")) {
            String resourceEnvRefName = (String)event.getData();
            if (resourceEnvRefName != null) {
                ContextResourceEnvRef resourceEnvRef = this.namingResources.findResourceEnvRef(resourceEnvRefName);
                this.addResourceEnvRef(resourceEnvRef);
            }
        } else if (type.equals("addService")) {
            String serviceName2 = (String)event.getData();
            if (serviceName2 != null) {
                ContextService service = this.namingResources.findService(serviceName2);
                this.addService(service);
            }
        } else if (type.equals("removeEjb")) {
            String ejbName = (String)event.getData();
            if (ejbName != null) {
                this.removeEjb(ejbName);
            }
        } else if (type.equals("removeEnvironment")) {
            String environmentName = (String)event.getData();
            if (environmentName != null) {
                this.removeEnvironment(environmentName);
            }
        } else if (type.equals("removeLocalEjb")) {
            String localEjbName = (String)event.getData();
            if (localEjbName != null) {
                this.removeLocalEjb(localEjbName);
            }
        } else if (type.equals("removeResource")) {
            String resourceName = (String)event.getData();
            if (resourceName != null) {
                this.removeResource(resourceName);
            }
        } else if (type.equals("removeResourceLink")) {
            String resourceLinkName = (String)event.getData();
            if (resourceLinkName != null) {
                this.removeResourceLink(resourceLinkName);
            }
        } else if (type.equals("removeResourceEnvRef")) {
            String resourceEnvRefName = (String)event.getData();
            if (resourceEnvRefName != null) {
                this.removeResourceEnvRef(resourceEnvRefName);
            }
        } else if (type.equals("removeService") && (serviceName = (String)event.getData()) != null) {
            this.removeService(serviceName);
        }
        ContextAccessController.setReadOnly(this.getName());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.initialized) {
            return;
        }
        Object source = event.getSource();
        if (source == this.namingResources) {
            ContextAccessController.setWritable(this.getName(), this.container);
            this.processGlobalResourcesChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
            ContextAccessController.setReadOnly(this.getName());
        }
    }

    private void processGlobalResourcesChange(String name, Object oldValue, Object newValue) {
        if (name.equals("ejb")) {
            ContextEjb ejb;
            if (oldValue != null && (ejb = (ContextEjb)oldValue).getName() != null) {
                this.removeEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextEjb)newValue).getName() != null) {
                this.addEjb(ejb);
            }
        } else if (name.equals("environment")) {
            ContextEnvironment env;
            if (oldValue != null && (env = (ContextEnvironment)oldValue).getName() != null) {
                this.removeEnvironment(env.getName());
            }
            if (newValue != null && (env = (ContextEnvironment)newValue).getName() != null) {
                this.addEnvironment(env);
            }
        } else if (name.equals("localEjb")) {
            ContextLocalEjb ejb;
            if (oldValue != null && (ejb = (ContextLocalEjb)oldValue).getName() != null) {
                this.removeLocalEjb(ejb.getName());
            }
            if (newValue != null && (ejb = (ContextLocalEjb)newValue).getName() != null) {
                this.addLocalEjb(ejb);
            }
        } else if (name.equals("resource")) {
            ContextResource resource;
            if (oldValue != null && (resource = (ContextResource)oldValue).getName() != null) {
                this.removeResource(resource.getName());
            }
            if (newValue != null && (resource = (ContextResource)newValue).getName() != null) {
                this.addResource(resource);
            }
        } else if (name.equals("resourceEnvRef")) {
            ContextResourceEnvRef resourceEnvRef;
            if (oldValue != null && (resourceEnvRef = (ContextResourceEnvRef)oldValue).getName() != null) {
                this.removeResourceEnvRef(resourceEnvRef.getName());
            }
            if (newValue != null && (resourceEnvRef = (ContextResourceEnvRef)newValue).getName() != null) {
                this.addResourceEnvRef(resourceEnvRef);
            }
        } else if (name.equals("resourceLink")) {
            ContextResourceLink rl;
            if (oldValue != null && (rl = (ContextResourceLink)oldValue).getName() != null) {
                this.removeResourceLink(rl.getName());
            }
            if (newValue != null && (rl = (ContextResourceLink)newValue).getName() != null) {
                this.addResourceLink(rl);
            }
        } else if (name.equals("service")) {
            ContextService service;
            if (oldValue != null && (service = (ContextService)oldValue).getName() != null) {
                this.removeService(service.getName());
            }
            if (newValue != null && (service = (ContextService)newValue).getName() != null) {
                this.addService(service);
            }
        }
    }

    private void createNamingContext() throws NamingException {
        int i;
        if (this.container instanceof Server) {
            this.compCtx = this.namingContext;
            this.envCtx = this.namingContext;
        } else {
            this.compCtx = this.namingContext.createSubcontext("comp");
            this.envCtx = this.compCtx.createSubcontext("env");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating JNDI naming context");
        }
        if (this.namingResources == null) {
            this.namingResources = new NamingResources();
            this.namingResources.setContainer(this.container);
        }
        ContextResourceLink[] resourceLinks = this.namingResources.findResourceLinks();
        for (i = 0; i < resourceLinks.length; ++i) {
            this.addResourceLink(resourceLinks[i]);
        }
        ContextResource[] resources = this.namingResources.findResources();
        for (i = 0; i < resources.length; ++i) {
            this.addResource(resources[i]);
        }
        ContextResourceEnvRef[] resourceEnvRefs = this.namingResources.findResourceEnvRefs();
        for (i = 0; i < resourceEnvRefs.length; ++i) {
            this.addResourceEnvRef(resourceEnvRefs[i]);
        }
        ContextEnvironment[] contextEnvironments = this.namingResources.findEnvironments();
        for (i = 0; i < contextEnvironments.length; ++i) {
            this.addEnvironment(contextEnvironments[i]);
        }
        ContextEjb[] ejbs = this.namingResources.findEjbs();
        for (i = 0; i < ejbs.length; ++i) {
            this.addEjb(ejbs[i]);
        }
        ContextService[] services = this.namingResources.findServices();
        for (i = 0; i < services.length; ++i) {
            this.addService(services[i]);
        }
        if (this.container instanceof Context) {
            try {
                TransactionRef ref = new TransactionRef();
                this.compCtx.bind("UserTransaction", (Object)ref);
                ContextTransaction transaction = this.namingResources.getTransaction();
                if (transaction != null) {
                    Iterator<String> params = transaction.listProperties();
                    while (params.hasNext()) {
                        String paramName = params.next();
                        String paramValue = (String)transaction.getProperty(paramName);
                        StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
                        ref.add(refAddr);
                    }
                }
            }
            catch (NameAlreadyBoundException e) {
            }
            catch (NamingException e) {
                this.logger.error(sm.getString("naming.bindFailed", e));
            }
        }
        if (this.container instanceof Context) {
            try {
                this.compCtx.bind("Resources", (Object)((Container)this.container).getResources());
            }
            catch (NamingException e) {
                this.logger.error(sm.getString("naming.bindFailed", e));
            }
        }
    }

    protected ObjectName createObjectName(ContextResource resource) throws MalformedObjectNameException {
        String domain = null;
        if (this.container instanceof StandardServer) {
            domain = ((StandardServer)this.container).getDomain();
        } else if (this.container instanceof ContainerBase) {
            domain = ((ContainerBase)this.container).getDomain();
        }
        if (domain == null) {
            domain = "Catalina";
        }
        ObjectName name = null;
        String quotedResourceName = ObjectName.quote(resource.getName());
        if (this.container instanceof Server) {
            name = new ObjectName(domain + ":type=DataSource" + ",class=" + resource.getType() + ",name=" + quotedResourceName);
        } else if (this.container instanceof Context) {
            String contextName = ((Context)this.container).getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            Host host = (Host)((Context)this.container).getParent();
            name = new ObjectName(domain + ":type=DataSource" + ",context=" + contextName + ",host=" + host.getName() + ",class=" + resource.getType() + ",name=" + quotedResourceName);
        }
        return name;
    }

    public void addEjb(ContextEjb ejb) {
        EjbRef ref = new EjbRef(ejb.getType(), ejb.getHome(), ejb.getRemote(), ejb.getLink());
        Iterator<String> params = ejb.listProperties();
        while (params.hasNext()) {
            String paramName = params.next();
            String paramValue = (String)ejb.getProperty(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
        try {
            this.createSubcontexts(this.envCtx, ejb.getName());
            this.envCtx.bind(ejb.getName(), (Object)ref);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.bindFailed", e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addEnvironment(ContextEnvironment env) {
        Object value = null;
        String type = env.getType();
        try {
            if (type.equals("java.lang.String")) {
                value = env.getValue();
            } else if (type.equals("java.lang.Byte")) {
                value = env.getValue() == null ? Byte.valueOf((byte)0) : Byte.decode(env.getValue());
            } else if (type.equals("java.lang.Short")) {
                value = env.getValue() == null ? Short.valueOf((short)0) : Short.decode(env.getValue());
            } else if (type.equals("java.lang.Integer")) {
                value = env.getValue() == null ? Integer.valueOf(0) : Integer.decode(env.getValue());
            } else if (type.equals("java.lang.Long")) {
                value = env.getValue() == null ? Long.valueOf(0L) : Long.decode(env.getValue());
            } else if (type.equals("java.lang.Boolean")) {
                value = Boolean.valueOf(env.getValue());
            } else if (type.equals("java.lang.Double")) {
                value = env.getValue() == null ? Double.valueOf(0.0) : Double.valueOf(env.getValue());
            } else if (type.equals("java.lang.Float")) {
                value = env.getValue() == null ? Float.valueOf(0.0f) : Float.valueOf(env.getValue());
            } else if (type.equals("java.lang.Character")) {
                if (env.getValue() == null) {
                    value = Character.valueOf('\u0000');
                } else {
                    if (env.getValue().length() != 1) throw new IllegalArgumentException();
                    value = Character.valueOf(env.getValue().charAt(0));
                }
            } else {
                this.logger.error(sm.getString("naming.invalidEnvEntryType", env.getName()));
            }
        }
        catch (NumberFormatException e) {
            this.logger.error(sm.getString("naming.invalidEnvEntryValue", env.getName()));
        }
        catch (IllegalArgumentException e) {
            this.logger.error(sm.getString("naming.invalidEnvEntryValue", env.getName()));
        }
        if (value == null) return;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Adding environment entry " + env.getName());
            }
            this.createSubcontexts(this.envCtx, env.getName());
            this.envCtx.bind(env.getName(), value);
            return;
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.invalidEnvEntryValue", e));
        }
    }

    public void addLocalEjb(ContextLocalEjb localEjb) {
    }

    public void addService(ContextService service) {
        if (service.getWsdlfile() != null) {
            URL wsdlURL = null;
            try {
                wsdlURL = new URL(service.getWsdlfile());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (wsdlURL == null) {
                try {
                    wsdlURL = ((Context)this.container).getServletContext().getResource(service.getWsdlfile());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (wsdlURL == null) {
                try {
                    wsdlURL = ((Context)this.container).getServletContext().getResource("/" + service.getWsdlfile());
                    this.logger.debug("  Changing service ref wsdl file for /" + service.getWsdlfile());
                }
                catch (MalformedURLException e) {
                    this.logger.error(sm.getString("naming.wsdlFailed", e));
                }
            }
            if (wsdlURL == null) {
                service.setWsdlfile(null);
            } else {
                service.setWsdlfile(wsdlURL.toString());
            }
        }
        if (service.getJaxrpcmappingfile() != null) {
            URL jaxrpcURL = null;
            try {
                jaxrpcURL = new URL(service.getJaxrpcmappingfile());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (jaxrpcURL == null) {
                try {
                    jaxrpcURL = ((Context)this.container).getServletContext().getResource(service.getJaxrpcmappingfile());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (jaxrpcURL == null) {
                try {
                    jaxrpcURL = ((Context)this.container).getServletContext().getResource("/" + service.getJaxrpcmappingfile());
                    this.logger.debug("  Changing service ref jaxrpc file for /" + service.getJaxrpcmappingfile());
                }
                catch (MalformedURLException e) {
                    this.logger.error(sm.getString("naming.wsdlFailed", e));
                }
            }
            if (jaxrpcURL == null) {
                service.setJaxrpcmappingfile(null);
            } else {
                service.setJaxrpcmappingfile(jaxrpcURL.toString());
            }
        }
        ServiceRef ref = new ServiceRef(service.getName(), service.getType(), service.getServiceqname(), service.getWsdlfile(), service.getJaxrpcmappingfile());
        Iterator<String> portcomponent = service.getServiceendpoints();
        while (portcomponent.hasNext()) {
            String serviceendpoint = portcomponent.next();
            StringRefAddr refAddr = new StringRefAddr("serviceendpointinterface", serviceendpoint);
            ref.add(refAddr);
            String portlink = service.getPortlink(serviceendpoint);
            refAddr = new StringRefAddr("portcomponentlink", portlink);
            ref.add(refAddr);
        }
        Iterator<String> handlers = service.getHandlers();
        while (handlers.hasNext()) {
            int i;
            String handlername = handlers.next();
            ContextHandler handler = service.getHandler(handlername);
            HandlerRef handlerRef = new HandlerRef(handlername, handler.getHandlerclass());
            Iterator<String> localParts = handler.getLocalparts();
            while (localParts.hasNext()) {
                String localPart = localParts.next();
                String namespaceURI = handler.getNamespaceuri(localPart);
                handlerRef.add(new StringRefAddr("handlerlocalpart", localPart));
                handlerRef.add(new StringRefAddr("handlernamespace", namespaceURI));
            }
            Iterator<String> params = handler.listProperties();
            while (params.hasNext()) {
                String paramName = params.next();
                String paramValue = (String)handler.getProperty(paramName);
                handlerRef.add(new StringRefAddr("handlerparamname", paramName));
                handlerRef.add(new StringRefAddr("handlerparamvalue", paramValue));
            }
            for (i = 0; i < handler.getSoapRolesSize(); ++i) {
                handlerRef.add(new StringRefAddr("handlersoaprole", handler.getSoapRole(i)));
            }
            for (i = 0; i < handler.getPortNamesSize(); ++i) {
                handlerRef.add(new StringRefAddr("handlerportname", handler.getPortName(i)));
            }
            ref.addHandler(handlerRef);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Adding service ref " + service.getName() + "  " + ref);
            }
            this.createSubcontexts(this.envCtx, service.getName());
            this.envCtx.bind(service.getName(), (Object)ref);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.bindFailed", e));
        }
    }

    public void addResource(ContextResource resource) {
        ResourceRef ref = new ResourceRef(resource.getType(), resource.getDescription(), resource.getScope(), resource.getAuth(), resource.getSingleton());
        Iterator<String> params = resource.listProperties();
        while (params.hasNext()) {
            String paramName = params.next();
            String paramValue = (String)resource.getProperty(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Adding resource ref " + resource.getName() + "  " + ref);
            }
            this.createSubcontexts(this.envCtx, resource.getName());
            this.envCtx.bind(resource.getName(), (Object)ref);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.bindFailed", e));
        }
        if ("javax.sql.DataSource".equals(ref.getClassName()) && resource.getSingleton()) {
            try {
                ObjectName on = this.createObjectName(resource);
                Object actualResource = this.envCtx.lookup(resource.getName());
                Registry.getRegistry(null, null).registerComponent(actualResource, on, null);
                this.objectNames.put(resource.getName(), on);
            }
            catch (Exception e) {
                this.logger.warn(sm.getString("naming.jmxRegistrationFailed", e));
            }
        }
    }

    public void addResourceEnvRef(ContextResourceEnvRef resourceEnvRef) {
        ResourceEnvRef ref = new ResourceEnvRef(resourceEnvRef.getType());
        Iterator<String> params = resourceEnvRef.listProperties();
        while (params.hasNext()) {
            String paramName = params.next();
            String paramValue = (String)resourceEnvRef.getProperty(paramName);
            StringRefAddr refAddr = new StringRefAddr(paramName, paramValue);
            ref.add(refAddr);
        }
        try {
            if (this.logger.isDebugEnabled()) {
                log.debug("  Adding resource env ref " + resourceEnvRef.getName());
            }
            this.createSubcontexts(this.envCtx, resourceEnvRef.getName());
            this.envCtx.bind(resourceEnvRef.getName(), (Object)ref);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.bindFailed", e));
        }
    }

    public void addResourceLink(ContextResourceLink resourceLink) {
        ResourceLinkRef ref = new ResourceLinkRef(resourceLink.getType(), resourceLink.getGlobal(), resourceLink.getFactory(), null);
        Iterator<String> i = resourceLink.listProperties();
        while (i.hasNext()) {
            String key = i.next().toString();
            Object val = resourceLink.getProperty(key);
            if (val == null) continue;
            StringRefAddr refAddr = new StringRefAddr(key, val.toString());
            ref.add(refAddr);
        }
        javax.naming.Context ctx = "UserTransaction".equals(resourceLink.getName()) ? this.compCtx : this.envCtx;
        try {
            if (this.logger.isDebugEnabled()) {
                log.debug("  Adding resource link " + resourceLink.getName());
            }
            this.createSubcontexts(this.envCtx, resourceLink.getName());
            ctx.bind(resourceLink.getName(), (Object)ref);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.bindFailed", e));
        }
    }

    public void removeEjb(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    public void removeEnvironment(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    public void removeLocalEjb(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    public void removeService(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    public void removeResource(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
        ObjectName on = this.objectNames.get(name);
        if (on != null) {
            Registry.getRegistry(null, null).unregisterComponent(on);
        }
    }

    public void removeResourceEnvRef(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    public void removeResourceLink(String name) {
        try {
            this.envCtx.unbind(name);
        }
        catch (NamingException e) {
            this.logger.error(sm.getString("naming.unbindFailed", e));
        }
    }

    private void createSubcontexts(javax.naming.Context ctx, String name) throws NamingException {
        javax.naming.Context currentContext = ctx;
        StringTokenizer tokenizer = new StringTokenizer(name, "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("") || !tokenizer.hasMoreTokens()) continue;
            try {
                currentContext = currentContext.createSubcontext(token);
            }
            catch (NamingException e) {
                currentContext = (javax.naming.Context)currentContext.lookup(token);
            }
        }
    }
}

