/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.Capability;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.Requirement;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.Module;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.Wire;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.PackagePermission;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResolverStateImpl
implements Resolver.ResolverState {
    private final Logger m_logger;
    private final Set<Module> m_modules;
    private final Set<Module> m_fragments;
    private final Map<String, CapabilitySet> m_capSets;
    private final String m_fwkExecEnvStr;
    private final Set<String> m_fwkExecEnvSet;

    ResolverStateImpl(Logger logger, String fwkExecEnvStr) {
        this.m_logger = logger;
        this.m_modules = new HashSet<Module>();
        this.m_fragments = new HashSet<Module>();
        this.m_capSets = new HashMap<String, CapabilitySet>();
        this.m_fwkExecEnvStr = fwkExecEnvStr != null ? fwkExecEnvStr.trim() : null;
        this.m_fwkExecEnvSet = ResolverStateImpl.parseExecutionEnvironments(fwkExecEnvStr);
        ArrayList<String> indices = new ArrayList<String>();
        indices.add("bundle-symbolic-name");
        this.m_capSets.put("module", new CapabilitySet(indices, true));
        indices = new ArrayList();
        indices.add("package");
        this.m_capSets.put("package", new CapabilitySet(indices, true));
        indices = new ArrayList();
        indices.add("bundle-symbolic-name");
        this.m_capSets.put("host", new CapabilitySet(indices, true));
    }

    synchronized void addModule(Module m) {
        this.m_modules.add(m);
        List<Capability> caps = m.getCapabilities();
        if (caps != null) {
            for (Capability cap : caps) {
                CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                if (capSet == null) {
                    capSet = new CapabilitySet(null, true);
                    this.m_capSets.put(cap.getNamespace(), capSet);
                }
                capSet.addCapability(cap);
            }
        }
        if (Util.isFragment(m)) {
            this.m_fragments.add(m);
        }
    }

    synchronized void removeModule(Module m) {
        this.m_modules.remove(m);
        List<Capability> caps = m.getCapabilities();
        if (caps != null) {
            for (Capability cap : caps) {
                CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                if (capSet == null) continue;
                capSet.removeCapability(cap);
            }
        }
        if (Util.isFragment(m)) {
            this.m_fragments.remove(m);
        }
    }

    synchronized Set<Module> getFragments() {
        return new HashSet<Module>(this.m_fragments);
    }

    synchronized void removeSubstitutedCapabilities(Module module) {
        if (module.isResolved()) {
            List<Wire> wires = module.getWires();
            List<Capability> caps = module.getCapabilities();
            block0: for (int wireIdx = 0; wires != null && wireIdx < wires.size(); ++wireIdx) {
                Wire wire = wires.get(wireIdx);
                if (!wire.getCapability().getNamespace().equals("package")) continue;
                for (int capIdx = 0; caps != null && capIdx < caps.size(); ++capIdx) {
                    if (!caps.get(capIdx).getNamespace().equals("package") || !wire.getCapability().getAttribute("package").getValue().equals(caps.get(capIdx).getAttribute("package").getValue())) continue;
                    this.m_capSets.get("package").removeCapability(caps.get(capIdx));
                    continue block0;
                }
            }
        }
    }

    @Override
    public synchronized SortedSet<Capability> getCandidates(Requirement req, boolean obeyMandatory) {
        Module module = req.getModule();
        TreeSet<Capability> result = new TreeSet<Capability>(new CandidateComparator());
        CapabilitySet capSet = this.m_capSets.get(req.getNamespace());
        if (capSet != null) {
            Set<Capability> matches = capSet.match(req.getFilter(), obeyMandatory);
            for (Capability cap : matches) {
                if (System.getSecurityManager() != null && (!req.getNamespace().equals("package") || ((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new PackagePermission((String)cap.getAttribute("package").getValue(), "exportonly")) && (module == null || ((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new PackagePermission((String)cap.getAttribute("package").getValue(), cap.getModule().getBundle(), "import"))) ? req.getNamespace().equals("module") && (!((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new BundlePermission(cap.getModule().getSymbolicName(), "provide")) || module != null && !((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new BundlePermission(module.getSymbolicName(), "require"))) || req.getNamespace().equals("host") && (!((BundleProtectionDomain)req.getModule().getSecurityContext()).impliesDirect(new BundlePermission(req.getModule().getSymbolicName(), "fragment")) || !((BundleProtectionDomain)cap.getModule().getSecurityContext()).impliesDirect(new BundlePermission(cap.getModule().getSymbolicName(), "host"))) : module != cap.getModule())) continue;
                if (req.getNamespace().equals("host") && cap.getModule().isResolved()) continue;
                result.add(cap);
            }
        }
        return result;
    }

    @Override
    public void checkExecutionEnvironment(Module module) throws ResolveException {
        String bundleExecEnvStr = (String)module.getHeaders().get("Bundle-RequiredExecutionEnvironment");
        if (bundleExecEnvStr != null && !(bundleExecEnvStr = bundleExecEnvStr.trim()).equals("") && this.m_fwkExecEnvStr != null && this.m_fwkExecEnvStr.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(bundleExecEnvStr, ",");
            boolean found = false;
            while (tokens.hasMoreTokens() && !found) {
                if (!this.m_fwkExecEnvSet.contains(tokens.nextToken().trim())) continue;
                found = true;
            }
            if (!found) {
                throw new ResolveException(new StringBuffer().append("Execution environment not supported: ").append(bundleExecEnvStr).toString(), module, null);
            }
        }
    }

    @Override
    public void checkNativeLibraries(Module module) throws ResolveException {
        List<R4Library> libs = module.getNativeLibraries();
        if (libs != null) {
            String msg = null;
            for (int libIdx = 0; msg == null && libIdx < libs.size(); ++libIdx) {
                String entryName = libs.get(libIdx).getEntryName();
                if (entryName == null || module.getContent().hasEntry(entryName)) continue;
                msg = new StringBuffer().append("Native library does not exist: ").append(entryName).toString();
            }
            if (libs.isEmpty()) {
                msg = "No matching native libraries found.";
            }
            if (msg != null) {
                throw new ResolveException(msg, module, null);
            }
        }
    }

    private static Set<String> parseExecutionEnvironments(String fwkExecEnvStr) {
        HashSet<String> newSet = new HashSet<String>();
        if (fwkExecEnvStr != null) {
            StringTokenizer tokens = new StringTokenizer(fwkExecEnvStr, ",");
            while (tokens.hasMoreTokens()) {
                newSet.add(tokens.nextToken().trim());
            }
        }
        return newSet;
    }
}

