/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.launcher.felix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOUtils {
    private IOUtils() {
    }

    public static boolean deleteDir(File dir) {
        File candir;
        if (!dir.isDirectory()) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean deleted = file.delete();
                if (deleted || !file.isDirectory()) continue;
                IOUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static String getSystemPath(File base, String relative) {
        return IOUtils.getSystemFile(base, relative).getPath();
    }

    public static File getSystemFile(File base, String relative) {
        return new File(base, relative.replace('/', File.separatorChar));
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static Properties getPropertiesFromFile(File filename) throws IOException {
        return IOUtils.loadPropertiesFromStream(new FileInputStream(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromStream(InputStream is) throws IOException {
        Properties config = new Properties();
        try {
            config.load(is);
        }
        finally {
            is.close();
        }
        return config;
    }

    public static Properties getPropertiesFromClass(String resource, Class<?> clazz) throws IOException {
        return IOUtils.loadPropertiesFromStream(clazz.getResourceAsStream(resource));
    }
}

