/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerImpl;

public final class StandardFilter
extends TokenFilter {
    private static final String APOSTROPHE_TYPE = StandardTokenizerImpl.TOKEN_TYPES[1];
    private static final String ACRONYM_TYPE = StandardTokenizerImpl.TOKEN_TYPES[2];

    public StandardFilter(TokenStream in) {
        super(in);
    }

    public final Token next(Token result) throws IOException {
        Token t = this.input.next(result);
        if (t == null) {
            return null;
        }
        char[] buffer = t.termBuffer();
        int bufferLength = t.termLength();
        String type = t.type();
        if (type == APOSTROPHE_TYPE && bufferLength >= 2 && buffer[bufferLength - 2] == '\'' && (buffer[bufferLength - 1] == 's' || buffer[bufferLength - 1] == 'S')) {
            t.setTermLength(bufferLength - 2);
        } else if (type == ACRONYM_TYPE) {
            int upto = 0;
            for (int i = 0; i < bufferLength; ++i) {
                char c = buffer[i];
                if (c == '.') continue;
                buffer[upto++] = c;
            }
            t.setTermLength(upto);
        }
        return t;
    }
}

