/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.jboss.util.file.BundleArchiveBrowser;
import org.jboss.util.file.DirectoryArchiveBrowser;
import org.jboss.util.file.JarArchiveBrowser;

public abstract class ArchiveBrowser {
    public static Iterator getBrowser(URL url, Filter filter) {
        if (url.getProtocol().equals("file")) {
            File f = null;
            try {
                f = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Not a valid URL: " + url, e);
            }
            if (f.isDirectory()) {
                return new DirectoryArchiveBrowser(f, filter);
            }
            return new JarArchiveBrowser(f, filter);
        }
        if (url.getProtocol().startsWith("bundle")) {
            return new BundleArchiveBrowser(url, filter);
        }
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

