/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.concurrent.ExecutorService;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.CloseIndexRunnable;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkVisitor;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PerDPResources {
    private final ExecutorService executor;
    private final LuceneWorkVisitor visitor;
    private final Workspace workspace;
    private final boolean exclusiveIndexUsage;
    private final ErrorHandler errorHandler;

    PerDPResources(SearchFactoryImplementor searchFactoryImp, DirectoryProvider<?> dp) {
        this.workspace = new Workspace(searchFactoryImp, dp);
        this.visitor = new LuceneWorkVisitor(this.workspace);
        this.executor = Executors.newFixedThreadPool(1, "Directory writer");
        this.exclusiveIndexUsage = searchFactoryImp.isExclusiveIndexUsageEnabled(dp);
        this.errorHandler = searchFactoryImp.getErrorHandler();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public LuceneWorkVisitor getVisitor() {
        return this.visitor;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isExclusiveIndexUsageEnabled() {
        return this.exclusiveIndexUsage;
    }

    public void shutdown() {
        if (this.exclusiveIndexUsage) {
            this.executor.execute(new CloseIndexRunnable(this.workspace));
        }
        this.executor.shutdown();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

