/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    public ServerIIOPConnection(Socket socket, boolean bl) throws IOException {
        this.socket = socket;
        this.use_ssl = bl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        IIOPAddress iIOPAddress = new IIOPAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
        this.profile = new IIOPProfile(iIOPAddress, null);
        this.profile.configure(configuration);
        this.connection_info = iIOPAddress.toString();
        this.connected = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opened new server-side TCP/IP transport to " + this.connection_info);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
            }
            catch (IOException iOException) {
                throw this.to_COMM_FAILURE(iOException);
            }
            this.socket = null;
            this.connected = false;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Closed server-side transport to " + this.connection_info);
            }
        }
    }

    public void connect(Profile profile, long l) {
    }
}

