/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio.util;

import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.transport.bio.util.SingleRemoveSynchronizedAddLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FastQueue {
    private static Log log = LogFactory.getLog(FastQueue.class);
    private SingleRemoveSynchronizedAddLock lock = new SingleRemoveSynchronizedAddLock();
    private LinkObject first = null;
    private LinkObject last = null;
    private int size = 0;
    private boolean checkLock = false;
    private boolean timeWait = false;
    private boolean inAdd = false;
    private boolean inRemove = false;
    private boolean inMutex = false;
    private int maxQueueLength = 0;
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private boolean enabled = true;
    private int maxSize = 0;
    private int sampleInterval = 100;

    public FastQueue() {
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public long getAddWaitTimeout() {
        this.addWaitTimeout = this.lock.getAddWaitTimeout();
        return this.addWaitTimeout;
    }

    public void setAddWaitTimeout(long timeout) {
        this.addWaitTimeout = timeout;
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
    }

    public long getRemoveWaitTimeout() {
        this.removeWaitTimeout = this.lock.getRemoveWaitTimeout();
        return this.removeWaitTimeout;
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.removeWaitTimeout = timeout;
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public void setMaxQueueLength(int length) {
        this.maxQueueLength = length;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        if (!this.enabled) {
            this.lock.abortRemove();
            this.first = null;
            this.last = null;
        }
    }

    public boolean isCheckLock() {
        return this.checkLock;
    }

    public void setCheckLock(boolean checkLock) {
        this.checkLock = checkLock;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public void unlockAdd() {
        this.lock.unlockAdd(this.size > 0);
    }

    public void unlockRemove() {
        this.lock.unlockRemove();
    }

    public void start() {
        this.setEnabled(true);
    }

    public void stop() {
        this.setEnabled(false);
    }

    public int getSize() {
        return this.size;
    }

    public SingleRemoveSynchronizedAddLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ChannelMessage msg, Member[] destination, InterceptorPayload payload) {
        boolean ok = true;
        long time = 0L;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info("FastQueue.add: queue disabled, add aborted");
            }
            return false;
        }
        if (this.timeWait) {
            time = System.currentTimeMillis();
        }
        this.lock.lockAdd();
        try {
            if (log.isTraceEnabled()) {
                log.trace("FastQueue.add: starting with size " + this.size);
            }
            if (this.checkLock) {
                if (this.inAdd) {
                    log.warn("FastQueue.add: Detected other add");
                }
                this.inAdd = true;
                if (this.inMutex) {
                    log.warn("FastQueue.add: Detected other mutex in add");
                }
                this.inMutex = true;
            }
            if (this.maxQueueLength > 0 && this.size >= this.maxQueueLength) {
                ok = false;
                if (log.isTraceEnabled()) {
                    log.trace("FastQueue.add: Could not add, since queue is full (" + this.size + ">=" + this.maxQueueLength + ")");
                }
            } else {
                LinkObject element = new LinkObject(msg, destination, payload);
                if (this.size == 0) {
                    this.first = this.last = element;
                    this.size = 1;
                } else if (this.last == null) {
                    ok = false;
                    log.error("FastQueue.add: Could not add, since last is null although size is " + this.size + " (>0)");
                } else {
                    this.last.append(element);
                    this.last = element;
                    ++this.size;
                }
            }
            if (this.first == null) {
                log.error("FastQueue.add: first is null, size is " + this.size + " at end of add");
            }
            if (this.last == null) {
                log.error("FastQueue.add: last is null, size is " + this.size + " at end of add");
            }
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn("FastQueue.add: Cancelled by other mutex in add");
                }
                this.inMutex = false;
                if (!this.inAdd) {
                    log.warn("FastQueue.add: Cancelled by other add");
                }
                this.inAdd = false;
            }
            if (log.isTraceEnabled()) {
                log.trace("FastQueue.add: add ending with size " + this.size);
            }
            Object var9_7 = null;
            this.lock.unlockAdd(true);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.lock.unlockAdd(true);
            throw throwable;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkObject remove() {
        long time;
        block19: {
            time = 0L;
            if (!this.enabled) {
                if (log.isInfoEnabled()) {
                    log.info("FastQueue.remove: queue disabled, remove aborted");
                }
                return null;
            }
            if (this.timeWait) {
                time = System.currentTimeMillis();
            }
            boolean gotLock = this.lock.lockRemove();
            try {
                if (gotLock) break block19;
                if (this.enabled) {
                    if (log.isInfoEnabled()) {
                        log.info("FastQueue.remove: Remove aborted although queue enabled");
                    }
                } else if (log.isInfoEnabled()) {
                    log.info("FastQueue.remove: queue disabled, remove aborted");
                }
                LinkObject linkObject = null;
                Object var7_4 = null;
                this.lock.unlockRemove();
                return linkObject;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.lock.unlockRemove();
                throw throwable;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("FastQueue.remove: remove starting with size " + this.size);
        }
        if (this.checkLock) {
            if (this.inRemove) {
                log.warn("FastQueue.remove: Detected other remove");
            }
            this.inRemove = true;
            if (this.inMutex) {
                log.warn("FastQueue.remove: Detected other mutex in remove");
            }
            this.inMutex = true;
        }
        LinkObject element = this.first;
        this.last = null;
        this.first = null;
        this.size = 0;
        if (this.checkLock) {
            if (!this.inMutex) {
                log.warn("FastQueue.remove: Cancelled by other mutex in remove");
            }
            this.inMutex = false;
            if (!this.inRemove) {
                log.warn("FastQueue.remove: Cancelled by other remove");
            }
            this.inRemove = false;
        }
        if (log.isTraceEnabled()) {
            log.trace("FastQueue.remove: remove ending with size " + this.size);
        }
        if (this.timeWait) {
            time = System.currentTimeMillis();
        }
        Object var7_5 = null;
        this.lock.unlockRemove();
        return element;
    }
}

