/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.servlet.ErrorPageErrorHandler;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.osgi.framework.BundleContext;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.base.War;
import org.ow2.jonas.web.base.osgi.httpservice.HttpServiceFactory;
import org.ow2.jonas.web.jetty6.AnnotationProcessorServletHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty6Service
extends BaseWebContainerService
implements JWebContainerService,
Pojo {
    private InstanceManager __IM;
    private static final String JETTY_CONFIGURATION_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6.xml";
    private static final String JETTY_DEFAULT_WEB_XML_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6-web.xml";
    private static String config = null;
    private boolean __Fserver;
    private Server server;
    private boolean __FdefaultHandler;
    private DefaultHandler defaultHandler;
    private boolean __FrequestLogHandler;
    private RequestLogHandler requestLogHandler;
    private boolean __FwebAppContexts;
    private ContextHandlerCollection webAppContexts;
    private boolean __Fhandlers;
    private HandlerCollection handlers;
    private boolean __FjettyStarted;
    private boolean jettyStarted;
    private boolean __MinitHandlers;
    private boolean __MdoStart;
    private boolean __MstartInternalWebContainer;
    private boolean __MisInternalContainerStarted;
    private boolean __MdoStop;
    private boolean __MdoRegisterWar$javax_naming_Context;
    private boolean __MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MgetJOnASClassPath$java_lang_ClassLoader;
    private boolean __MdoUnRegisterWar$javax_naming_Context;
    private boolean __MupdateServerInfos;
    private boolean __MgetDefaultHost;
    private boolean __MgetDefaultHttpPort;
    private boolean __MgetDefaultHttpsPort;
    private boolean __MgetFirstListenerFromScheme$java_lang_String;
    private boolean __McreateHttpServiceFactory;

    Server __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (Server)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(Server server) {
        if (!this.__Fserver) {
            this.server = server;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)server);
    }

    DefaultHandler __getdefaultHandler() {
        if (!this.__FdefaultHandler) {
            return this.defaultHandler;
        }
        return (DefaultHandler)this.__IM.onGet((Object)this, "defaultHandler");
    }

    void __setdefaultHandler(DefaultHandler defaultHandler) {
        if (!this.__FdefaultHandler) {
            this.defaultHandler = defaultHandler;
            return;
        }
        this.__IM.onSet((Object)this, "defaultHandler", (Object)defaultHandler);
    }

    RequestLogHandler __getrequestLogHandler() {
        if (!this.__FrequestLogHandler) {
            return this.requestLogHandler;
        }
        return (RequestLogHandler)this.__IM.onGet((Object)this, "requestLogHandler");
    }

    void __setrequestLogHandler(RequestLogHandler requestLogHandler) {
        if (!this.__FrequestLogHandler) {
            this.requestLogHandler = requestLogHandler;
            return;
        }
        this.__IM.onSet((Object)this, "requestLogHandler", (Object)requestLogHandler);
    }

    ContextHandlerCollection __getwebAppContexts() {
        if (!this.__FwebAppContexts) {
            return this.webAppContexts;
        }
        return (ContextHandlerCollection)this.__IM.onGet((Object)this, "webAppContexts");
    }

    void __setwebAppContexts(ContextHandlerCollection contextHandlerCollection) {
        if (!this.__FwebAppContexts) {
            this.webAppContexts = contextHandlerCollection;
            return;
        }
        this.__IM.onSet((Object)this, "webAppContexts", (Object)contextHandlerCollection);
    }

    HandlerCollection __gethandlers() {
        if (!this.__Fhandlers) {
            return this.handlers;
        }
        return (HandlerCollection)this.__IM.onGet((Object)this, "handlers");
    }

    void __sethandlers(HandlerCollection handlerCollection) {
        if (!this.__Fhandlers) {
            this.handlers = handlerCollection;
            return;
        }
        this.__IM.onSet((Object)this, "handlers", (Object)handlerCollection);
    }

    boolean __getjettyStarted() {
        if (!this.__FjettyStarted) {
            return this.jettyStarted;
        }
        Object object = this.__IM.onGet((Object)this, "jettyStarted");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setjettyStarted(boolean bl) {
        if (!this.__FjettyStarted) {
            this.jettyStarted = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "jettyStarted", (Object)bl2);
    }

    public Jetty6Service(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private Jetty6Service(InstanceManager _manager, BundleContext bundleContext) {
        super(bundleContext);
        this._setInstanceManager(_manager);
        this.__setserver(null);
        this.__setdefaultHandler(null);
        this.__setrequestLogHandler(null);
        this.__setwebAppContexts(null);
        this.__setjettyStarted(false);
    }

    private void initHandlers() {
        if (!this.__MinitHandlers) {
            this.__initHandlers();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "initHandlers", new Object[0]);
            this.__initHandlers();
            this.__IM.onExit((Object)this, "initHandlers", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "initHandlers", throwable);
            throw throwable;
        }
    }

    private void __initHandlers() {
        this.__setdefaultHandler(new DefaultHandler());
        this.__setrequestLogHandler(new RequestLogHandler());
        this.__setwebAppContexts(new ContextHandlerCollection());
        this.__sethandlers(new HandlerCollection());
        this.__gethandlers().setHandlers(new Handler[]{this.__getwebAppContexts(), this.__getdefaultHandler(), this.__getrequestLogHandler()});
        this.__getserver().setHandler((Handler)this.__gethandlers());
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (!this.isOnDemandFeatureEnabled()) {
            this.startInternalWebContainer();
        }
        super.doStart();
    }

    public synchronized void startInternalWebContainer() throws JWebContainerServiceException {
        if (!this.__MstartInternalWebContainer) {
            this.__startInternalWebContainer();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startInternalWebContainer", new Object[0]);
            this.__startInternalWebContainer();
            this.__IM.onExit((Object)this, "startInternalWebContainer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startInternalWebContainer", throwable);
            throw throwable;
        }
    }

    private void __startInternalWebContainer() throws JWebContainerServiceException {
        if (this.__getjettyStarted()) {
            return;
        }
        config = JETTY_CONFIGURATION_FILE;
        Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)("Using configuration file " + config));
        this.__setserver(new Server());
        this.initHandlers();
        if (this.__getserver() != null) {
            if (config != null) {
                IExecution<Server> jettyServerConfiguration = new IExecution<Server>(){

                    public Server execute() throws Exception {
                        Connector[] connectors;
                        XmlConfiguration configuration = new XmlConfiguration(new File(config).toURL());
                        configuration.configure((Object)Jetty6Service.this.__getserver());
                        if (Jetty6Service.this.isOnDemandFeatureEnabled() && (connectors = Jetty6Service.this.__getserver().getConnectors()).length >= 1) {
                            Connector connector = connectors[0];
                            connector.setPort(Jetty6Service.this.getOnDemandRedirectPort());
                        }
                        Jetty6Service.this.__getserver().start();
                        return Jetty6Service.this.__getserver();
                    }
                };
                ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)jettyServerConfiguration);
                if (result.hasException()) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("Error has occured while starting Jetty server using configuration file " + config), (Throwable)result.getException());
                }
            }
        } else {
            throw new ServiceException("Cannot start Jetty server.");
        }
        Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service started");
        this.__setjettyStarted(true);
    }

    public boolean isInternalContainerStarted() {
        boolean bl;
        if (!this.__MisInternalContainerStarted) {
            return this.__isInternalContainerStarted();
        }
        try {
            this.__IM.onEntry((Object)this, "isInternalContainerStarted", new Object[0]);
            bl = this.__isInternalContainerStarted();
            this.__IM.onExit((Object)this, "isInternalContainerStarted", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isInternalContainerStarted", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isInternalContainerStarted() {
        return this.__getjettyStarted();
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        super.doStop();
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.isStarted() && this.__getserver() != null) {
            try {
                this.__getserver().stop();
                this.__getserver().destroy();
                this.__setserver(null);
                Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service stopped");
            }
            catch (Exception eExc) {
                Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("error has occured while stopping Jetty server using configuration file " + config), (Throwable)eExc);
            }
        }
        this.__setjettyStarted(false);
    }

    protected void doRegisterWar(Context context) throws JWebContainerServiceException {
        if (!this.__MdoRegisterWar$javax_naming_Context) {
            this.__doRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doRegisterWar$javax_naming_Context", new Object[]{context});
            this.__doRegisterWar(context);
            this.__IM.onExit((Object)this, "doRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void __doRegisterWar(Context ctx) throws JWebContainerServiceException {
        unpackedWarURL = null;
        contextRoot = null;
        war = null;
        java2DelegationModel = true;
        try {
            war = (War)ctx.lookup("war");
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
        }
        catch (NamingException e) {
            err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            err = "error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        hostName = null;
        earAppName = null;
        try {
            earAppName = (String)ctx.lookup("earAppName");
        }
        catch (NamingException e) {
            earAppName = null;
        }
        webDD = null;
        try {
            webDD = (WebContainerDeploymentDesc)ctx.lookup("webDD");
        }
        catch (NamingException e) {
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)"Unable to get default parameters", (Throwable)e);
            throw new JWebContainerServiceException("Unable to get default parameters", (Throwable)e);
        }
        contextRoot = war.getContextRoot();
        java2DelegationModel = war.getJava2DelegationModel();
        hostName = war.getHostName();
        if (hostName == null) {
            hostName = "";
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        fWar = new File(unpackedWarURL.getFile());
        fileName = fWar.getAbsolutePath();
        if (this.__getserver() != null) {
            try {
                securityHandler = new SecurityHandler();
                sessionHandler = new SessionHandler();
                errorHandler = new ErrorPageErrorHandler();
                envCtx = null;
                try {
                    envCtx = (Context)this.getNaming().getComponentContext(webClassLoader).lookup("comp/env");
                }
                catch (NamingException e) {
                    Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)("Cannot get the context of the webapplication '" + war.getWarURL() + "'."), (Throwable)e);
                }
                servletHandler = new AnnotationProcessorServletHandler(envCtx);
                servletHandler.setEncBindingHolder(webDD.getENCBindingHolder());
                webAppContext = new WebAppContext(securityHandler, sessionHandler, (ServletHandler)servletHandler, (ErrorHandler)errorHandler);
                webAppContext.setContextPath("/" + contextRoot);
                webAppContext.setWar(unpackedWarURL.toString());
                if (hostName != null && hostName.length() > 0) {
                    webAppContext.setConnectorNames(new String[]{hostName});
                }
                webAppContext.setAttribute("J2EEDomainName", (Object)this.getDomainName());
                webAppContext.setAttribute("J2EEServerName", (Object)this.getJonasServerName());
                webAppContext.setAttribute("J2EEApplicationName", (Object)earAppName);
                webDefaults = new File(Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE);
                if (webDefaults.exists()) {
                    webAppContext.setDefaultsDescriptor(webDefaults.toURL().toExternalForm());
                } else {
                    Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("The file '" + Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE + "' is not present. Check that your JONAS_BASE is up-to-date."));
                }
                webAppContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)this.getJOnASClassPath(webClassLoader));
                webAppContext.setParentLoaderPriority(java2DelegationModel);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server starting web app " + fileName));
                }
                this.__getwebAppContexts().addHandler((Handler)webAppContext);
                oldCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(webClassLoader);
                try {
                    webAppContext.start();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                war.setClassLoader(webAppContext.getClassLoader());
                if (!Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) ** GOTO lbl102
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server is running web app " + fileName));
            }
            catch (IOException ioeExc) {
                err = "Cannot install this web application " + ioeExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)ioeExc);
            }
            catch (Exception eExc) {
                err = "Cannot start this web application " + eExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)eExc);
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app " + fileName));
        }
lbl102:
        // 5 sources

        try {
            ctx.rebind("WebModule", (Object)this.getDummyJSR77ObjectName(hostName, contextRoot, earAppName));
        }
        catch (Exception e) {
            err = "Cannot rebind WebModule ObjectName in Context";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    private ObjectName getDummyJSR77ObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        ObjectName objectName;
        if (!this.__MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String) {
            return this.__getDummyJSR77ObjectName(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            objectName = this.__getDummyJSR77ObjectName(string, string2, string3);
            this.__IM.onExit((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", (Object)objectName);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return objectName;
    }

    private ObjectName __getDummyJSR77ObjectName(String hostName, String contextRoot, String earAppName) throws MalformedObjectNameException {
        return ObjectName.getInstance(this.getDomainName() + ":j2eeType=WebModule,name=" + "/" + contextRoot + ",J2EEApplication=" + earAppName + ",J2EEServer=" + this.getJonasServerName());
    }

    public String getJOnASClassPath(ClassLoader classLoader) {
        String string;
        if (!this.__MgetJOnASClassPath$java_lang_ClassLoader) {
            return this.__getJOnASClassPath(classLoader);
        }
        try {
            this.__IM.onEntry((Object)this, "getJOnASClassPath$java_lang_ClassLoader", new Object[]{classLoader});
            string = this.__getJOnASClassPath(classLoader);
            this.__IM.onExit((Object)this, "getJOnASClassPath$java_lang_ClassLoader", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getJOnASClassPath$java_lang_ClassLoader", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getJOnASClassPath(ClassLoader webClassLoader) {
        StringBuffer classpath = new StringBuffer();
        int n = 0;
        for (ClassLoader tmpLoader = webClassLoader; tmpLoader != null && tmpLoader instanceof URLClassLoader; tmpLoader = tmpLoader.getParent()) {
            URL[] repositories = ((URLClassLoader)tmpLoader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring("file://".length());
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = repository.substring("file:".length());
                }
                if (repository == null) continue;
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
                ++n;
            }
        }
        return classpath.toString();
    }

    protected void doUnRegisterWar(Context context) throws JWebContainerServiceException {
        if (!this.__MdoUnRegisterWar$javax_naming_Context) {
            this.__doUnRegisterWar(context);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doUnRegisterWar$javax_naming_Context", new Object[]{context});
            this.__doUnRegisterWar(context);
            this.__IM.onExit((Object)this, "doUnRegisterWar$javax_naming_Context", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doUnRegisterWar$javax_naming_Context", throwable);
            throw throwable;
        }
    }

    private void __doUnRegisterWar(Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        if (this.__getserver() != null) {
            Handler[] handlers;
            WebAppContext webAppContext = null;
            for (Handler handler : handlers = this.__getwebAppContexts().getHandlers()) {
                WebAppContext tmpContext;
                String contextPath;
                if (!(handler instanceof WebAppContext) || !contextRoot.equals(contextPath = (tmpContext = (WebAppContext)handler).getContextPath())) continue;
                webAppContext = tmpContext;
                break;
            }
            if (webAppContext != null) {
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server found and is stopping web app at context " + contextRoot));
                }
                try {
                    webAppContext.stop();
                }
                catch (Exception e) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)"Jetty server encoutered exception while stopping web application ", (Throwable)e);
                }
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server stopped and is removing web app at context " + contextRoot));
                }
                this.__getwebAppContexts().removeHandler(webAppContext);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server removed and is destroying web app at context " + contextRoot));
                }
                webAppContext.destroy();
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server unloaded web app at context " + contextRoot));
                }
            } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server didn't find web app at context " + contextRoot));
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app at context " + contextRoot));
        }
    }

    protected void updateServerInfos() {
        if (!this.__MupdateServerInfos) {
            this.__updateServerInfos();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateServerInfos", new Object[0]);
            this.__updateServerInfos();
            this.__IM.onExit((Object)this, "updateServerInfos", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateServerInfos", throwable);
            throw throwable;
        }
    }

    private void __updateServerInfos() {
        this.setServerName("Jetty");
        this.setServerVersion(Server.getVersion());
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHost) {
            return this.__getDefaultHost();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHost", new Object[0]);
            string = this.__getDefaultHost();
            this.__IM.onExit((Object)this, "getDefaultHost", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHost", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultHost() throws JWebContainerServiceException {
        Connector[] connectors = this.__getserver().getConnectors();
        if (connectors.length == 0) {
            String err = "Cannot determine default host : Jetty server has no host!";
            throw new JWebContainerServiceException(err);
        }
        return connectors[0].getHost();
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpPort) {
            return this.__getDefaultHttpPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpPort", new Object[0]);
            string = this.__getDefaultHttpPort();
            this.__IM.onExit((Object)this, "getDefaultHttpPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultHttpPort() throws JWebContainerServiceException {
        if (!this.__getjettyStarted()) {
            return System.getProperty("jetty.port", "9000");
        }
        return String.valueOf(this.getFirstListenerFromScheme("http").getPort());
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        String string;
        if (!this.__MgetDefaultHttpsPort) {
            return this.__getDefaultHttpsPort();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultHttpsPort", new Object[0]);
            string = this.__getDefaultHttpsPort();
            this.__IM.onExit((Object)this, "getDefaultHttpsPort", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultHttpsPort", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getFirstListenerFromScheme("https").getPort());
    }

    private Connector getFirstListenerFromScheme(String string) {
        Connector connector;
        if (!this.__MgetFirstListenerFromScheme$java_lang_String) {
            return this.__getFirstListenerFromScheme(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getFirstListenerFromScheme$java_lang_String", new Object[]{string});
            connector = this.__getFirstListenerFromScheme(string);
            this.__IM.onExit((Object)this, "getFirstListenerFromScheme$java_lang_String", (Object)connector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFirstListenerFromScheme$java_lang_String", throwable);
            throw throwable;
        }
        return connector;
    }

    private Connector __getFirstListenerFromScheme(String myScheme) {
        Connector[] connectors = this.__getserver().getConnectors();
        ArrayList<Connector> matchingConnectors = new ArrayList<Connector>();
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = connectors[i];
            String scheme = connector.getIntegralScheme();
            if (!scheme.equalsIgnoreCase(myScheme)) continue;
            matchingConnectors.add(connector);
        }
        if (matchingConnectors.isEmpty()) {
            String err = "Cannot determine default '" + myScheme + "' port :" + " Jetty server has 0 '" + myScheme + "' Listener";
            throw new JWebContainerServiceException(err);
        }
        Connector firstConnector = (Connector)matchingConnectors.get(0);
        if (matchingConnectors.size() > 1 && Jetty6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Listener for scheme '" + myScheme + "'" + ", using first by default! (port:" + firstConnector.getPort() + ")"));
        }
        return firstConnector;
    }

    protected HttpServiceFactory<Jetty6Service> createHttpServiceFactory() {
        HttpServiceFactory<Jetty6Service> httpServiceFactory;
        if (!this.__McreateHttpServiceFactory) {
            return this.__createHttpServiceFactory();
        }
        try {
            this.__IM.onEntry((Object)this, "createHttpServiceFactory", new Object[0]);
            httpServiceFactory = this.__createHttpServiceFactory();
            this.__IM.onExit((Object)this, "createHttpServiceFactory", httpServiceFactory);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createHttpServiceFactory", throwable);
            throw throwable;
        }
        return httpServiceFactory;
    }

    private HttpServiceFactory<Jetty6Service> __createHttpServiceFactory() {
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("defaultHandler")) {
                this.__FdefaultHandler = true;
            }
            if (set.contains("jettyStarted")) {
                this.__FjettyStarted = true;
            }
            if (set.contains("webAppContexts")) {
                this.__FwebAppContexts = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
            if (set.contains("requestLogHandler")) {
                this.__FrequestLogHandler = true;
            }
            if (set.contains("handlers")) {
                this.__Fhandlers = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("initHandlers")) {
                this.__MinitHandlers = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("startInternalWebContainer")) {
                this.__MstartInternalWebContainer = true;
            }
            if (set.contains("isInternalContainerStarted")) {
                this.__MisInternalContainerStarted = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("doRegisterWar$javax_naming_Context")) {
                this.__MdoRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("getDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MgetDummyJSR77ObjectName$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getJOnASClassPath$java_lang_ClassLoader")) {
                this.__MgetJOnASClassPath$java_lang_ClassLoader = true;
            }
            if (set.contains("doUnRegisterWar$javax_naming_Context")) {
                this.__MdoUnRegisterWar$javax_naming_Context = true;
            }
            if (set.contains("updateServerInfos")) {
                this.__MupdateServerInfos = true;
            }
            if (set.contains("getDefaultHost")) {
                this.__MgetDefaultHost = true;
            }
            if (set.contains("getDefaultHttpPort")) {
                this.__MgetDefaultHttpPort = true;
            }
            if (set.contains("getDefaultHttpsPort")) {
                this.__MgetDefaultHttpsPort = true;
            }
            if (set.contains("getFirstListenerFromScheme$java_lang_String")) {
                this.__MgetFirstListenerFromScheme$java_lang_String = true;
            }
            if (set.contains("createHttpServiceFactory")) {
                this.__McreateHttpServiceFactory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

