/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.listener;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.listener.IPoolListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolListenerDispatcherPool<E>
implements IPool<E> {
    private static final Log LOG = LogFactory.getLog(PoolListenerDispatcherPool.class);
    private IPool<E> pool;
    private List<IPoolListener<E>> poolListenerList;

    public PoolListenerDispatcherPool(IPool<E> pool) {
        this.pool = pool;
        this.poolListenerList = new ArrayList<IPoolListener<E>>();
    }

    @Override
    public E get(IWaitControl timeout) throws PoolException, InterruptedException {
        for (IPoolListener<E> poolListener : this.poolListenerList) {
            try {
                poolListener.getMethodCalled(timeout);
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Listener failed", new Object[]{re});
            }
        }
        try {
            E result = this.pool.get(timeout);
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.getMethodReturned(result, timeout);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            return result;
        }
        catch (PoolException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.getMethodFailed(e, timeout);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
        catch (InterruptedException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.getMethodFailed(e, timeout);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.getMethodFailed(e, timeout);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
    }

    @Override
    public void signalAllWaiters() {
        for (IPoolListener<E> poolListener : this.poolListenerList) {
            try {
                poolListener.signalAllWaitersMethodCalled();
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Listener failed", new Object[]{re});
            }
        }
        try {
            this.pool.signalAllWaiters();
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.signalAllWaitersMethodReturned();
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
        }
        catch (RuntimeException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.signalAllWaitersMethodFailed(e);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
    }

    @Override
    public void put(E poolItem) throws NotABusyPoolItemException {
        for (IPoolListener<E> poolListener : this.poolListenerList) {
            try {
                poolListener.putMethodCalled(poolItem);
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Listener failed", new Object[]{re});
            }
        }
        try {
            this.pool.put(poolItem);
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.putMethodReturned(poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
        }
        catch (NotABusyPoolItemException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.putMethodFailed(e, poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.putMethodFailed(e, poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
    }

    @Override
    public void remove(E poolItem) throws NotABusyPoolItemException {
        for (IPoolListener<E> poolListener : this.poolListenerList) {
            try {
                poolListener.removeMethodCalled(poolItem);
            }
            catch (RuntimeException re) {
                LOG.error((Object)"Listener failed", new Object[]{re});
            }
        }
        try {
            this.pool.remove(poolItem);
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.removeMethodReturned(poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
        }
        catch (NotABusyPoolItemException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.removeMethodFailed(e, poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (IPoolListener<E> poolListener : this.poolListenerList) {
                try {
                    poolListener.removeMethodFailed(e, poolItem);
                }
                catch (RuntimeException re) {
                    LOG.error((Object)"Listener failed", new Object[]{re});
                }
            }
            throw e;
        }
    }

    public void addPoolListener(IPoolListener<E> poolListener) {
        this.poolListenerList.add(poolListener);
    }

    public void removePoolListener(IPoolListener<E> poolListener) {
        this.poolListenerList.remove(poolListener);
    }
}

