/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.resizer.impl;

import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizable;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.ManagementThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousResizer<S>
implements IResizer<S>,
Runnable {
    private ManagementThread[] managementThreads;
    private IResizer<S> resizer;
    private boolean willRun;

    public AsynchronousResizer(IResizer<S> poolResizer) {
        this(poolResizer, 1);
    }

    public AsynchronousResizer(IResizer<S> poolResizer, int threadCount) {
        this.resizer = poolResizer;
        this.managementThreads = new ManagementThread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            this.managementThreads[i] = new ManagementThread(this);
        }
    }

    @Override
    public void prepareUpdate(S state) {
        this.resizer.prepareUpdate(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        ManagementThread[] managementThreadArray = this.managementThreads;
        synchronized (this.managementThreads) {
            this.willRun = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (int i = 0; i < this.managementThreads.length; ++i) {
                this.managementThreads[i].start();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ManagementThread[] managementThreadArray = this.managementThreads;
        synchronized (this.managementThreads) {
            boolean doUpdate = this.willRun;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (doUpdate) {
                this.resizer.update();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResizable(IResizable resizable) {
        ManagementThread[] managementThreadArray = this.managementThreads;
        synchronized (this.managementThreads) {
            this.willRun = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.resizer.setResizable(resizable);
            return;
        }
    }
}

