/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.NoWaitControl;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared.SharedResizerOneThreadManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedResizerPoolThreadManager
extends SharedResizerOneThreadManager {
    private static final Log LOG = LogFactory.getLog(SharedResizerPoolThreadManager.class);
    private IPool<IReusableThread> reusableThreadPool;

    public SharedResizerPoolThreadManager(IPool<IReusableThread> reusableThreadPool) {
        this.reusableThreadPool = reusableThreadPool;
    }

    @Override
    public void update(IResizer<?> resizer) {
        super.update(resizer);
        try {
            this.reusableThreadPool.get(NoWaitControl.INSTANCE).setUsed(this.reusableThreadPool, this);
        }
        catch (PoolException e) {
            LOG.debug((Object)"Unable to get a pool item, manager thread will be used", new Object[]{e});
        }
        catch (InterruptedException e) {
            LOG.debug((Object)"Unable to get a pool item, manager thread will be used", new Object[]{e});
        }
    }
}

