/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.internal.thread.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.internal.thread.api.IManagementThread;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.CleanableWeakReference;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagementThread
extends CleanableWeakReference<Runnable>
implements Runnable,
IManagementThread {
    private static final Log LOG = LogFactory.getLog(ManagementThread.class);
    private static AtomicLong instanceCount = new AtomicLong(0L);
    private static Cleaner cleaner = new Cleaner();
    private boolean updateNeeded = false;
    private Object mutex = new Object();

    public ManagementThread(Runnable runnable) {
        this(runnable, true);
    }

    public ManagementThread(Runnable runnable, boolean daemon) {
        super(runnable, cleaner);
        Thread thread = new Thread((Runnable)this, "Management thread " + instanceCount.getAndIncrement());
        thread.setDaemon(daemon);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable runnable;
        block5: while ((runnable = (Runnable)this.get()) != null) {
            Object object = this.mutex;
            synchronized (object) {
                while (!this.updateNeeded) {
                    runnable = null;
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)"InterruptedException occurs", new Object[]{e});
                    }
                    if ((runnable = (Runnable)this.get()) != null) continue;
                    break block5;
                }
                this.updateNeeded = false;
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mutex;
        synchronized (object) {
            this.updateNeeded = true;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }
}

