/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.coerce;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.util.CoercionException;
import org.jboss.util.NotImplementedException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.coerce.BoundCoercionHandler;
import org.jboss.util.coerce.CharacterHandler;
import org.jboss.util.coerce.ClassHandler;
import org.jboss.util.coerce.FileHandler;

public abstract class CoercionHandler {
    private static Map handlers = Collections.synchronizedMap(new HashMap());

    public abstract Object coerce(Object var1, Class var2) throws CoercionException;

    public Class getType() {
        throw new NotImplementedException("handler is not bound");
    }

    public static void install(Class type, CoercionHandler handler) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        if (handler == null) {
            throw new NullArgumentException("handler");
        }
        handlers.put(type, handler);
    }

    public static void install(BoundCoercionHandler handler) {
        if (handler == null) {
            throw new NullArgumentException("handler");
        }
        handlers.put(handler.getType(), handler);
    }

    public static void uninstall(Class type) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        handlers.remove(type);
    }

    public static boolean isInstalled(Class type) {
        return handlers.containsKey(type);
    }

    public static CoercionHandler lookup(Class type) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        return (CoercionHandler)handlers.get(type);
    }

    public static CoercionHandler create(Class type) {
        CoercionHandler handler = CoercionHandler.lookup(type);
        if (handler == null) {
            throw new CoercionException("no installed handler for type: " + type);
        }
        return handler;
    }

    static {
        CoercionHandler.install(new CharacterHandler());
        CoercionHandler.install(new ClassHandler());
        CoercionHandler.install(new FileHandler());
    }
}

