/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.axis2.easybeans;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.ws.Binding;
import javax.xml.ws.Provider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.InvocationContextFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.axis2.easybeans.Axis2EndpointController;
import org.ow2.jonas.ws.axis2.jaxws.Axis2WSEndpoint;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2EjbMessageReceiver
implements MessageReceiver {
    private static final Log LOG = LogFactory.getLog(Axis2EjbMessageReceiver.class);
    private StatelessSessionFactory factory;
    private Class serviceImplClass;
    private Axis2WSEndpoint endpoint;

    public Axis2EjbMessageReceiver(Axis2WSEndpoint endpoint, Class serviceImplClass, StatelessSessionFactory factory) {
        this.endpoint = endpoint;
        this.serviceImplClass = serviceImplClass;
        this.factory = factory;
    }

    public void receive(MessageContext axisMsgCtx) throws AxisFault {
        org.apache.axis2.jaxws.core.MessageContext requestMsgCtx = new org.apache.axis2.jaxws.core.MessageContext(axisMsgCtx);
        requestMsgCtx.setOperationName(requestMsgCtx.getAxisMessageContext().getAxisOperation().getName());
        requestMsgCtx.setEndpointDescription(this.getEndpointDescription(requestMsgCtx));
        Method method = null;
        if (Provider.class.isAssignableFrom(this.serviceImplClass)) {
            method = this.getProviderMethod();
        } else {
            requestMsgCtx.setOperationDescription(this.getOperationDescription(requestMsgCtx));
            method = this.getServiceMethod(requestMsgCtx);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoking '" + method.getName() + "' method."), new Object[0]);
        }
        AxisOperation operation = requestMsgCtx.getAxisMessageContext().getAxisOperation();
        String mep = operation.getMessageExchangePattern();
        Axis2EndpointController controller = new Axis2EndpointController(this.factory);
        Binding binding = (Binding)requestMsgCtx.getAxisMessageContext().getProperty(JAXWSMessageReceiver.PARAM_BINDING);
        EndpointInvocationContext ic = InvocationContextFactory.createEndpointInvocationContext((Binding)binding);
        ic.setRequestMessageContext(requestMsgCtx);
        controller.invoke(ic);
        org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = ic.getResponseMessageContext();
        if (!this.isMepInOnly(mep) || this.hasFault(responseMsgCtx)) {
            MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
            MessageUtils.putMessageOnMessageContext((Message)responseMsgCtx.getMessage(), (MessageContext)axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            if (responseMsgCtx.getMessage().isFault()) {
                throw new AxisFault("An error was detected during JAXWS processing", axisResponseMsgCtx);
            }
            AxisEngine.send((MessageContext)axisResponseMsgCtx);
        }
    }

    private boolean hasFault(org.apache.axis2.jaxws.core.MessageContext responseMsgCtx) {
        if (responseMsgCtx == null || responseMsgCtx.getMessage() == null) {
            return false;
        }
        return responseMsgCtx.getMessage().isFault();
    }

    private boolean isMepInOnly(String mep) {
        boolean inOnly = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2006/01/wsdl/in-only");
        return inOnly;
    }

    private Method getServiceMethod(org.apache.axis2.jaxws.core.MessageContext mc) {
        OperationDescription opDesc = mc.getOperationDescription();
        if (opDesc == null) {
            throw ExceptionFactory.makeWebServiceException((String)"Operation Description was not set");
        }
        Method returnMethod = opDesc.getMethodFromServiceImpl(this.serviceImplClass);
        if (returnMethod == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"JavaBeanDispatcherErr1"));
        }
        return returnMethod;
    }

    private OperationDescription getOperationDescription(org.apache.axis2.jaxws.core.MessageContext mc) {
        EndpointDescription ed = mc.getEndpointDescription();
        EndpointInterfaceDescription eid = ed.getEndpointInterfaceDescription();
        OperationDescription[] ops = eid.getDispatchableOperation(mc.getOperationName());
        if (ops == null || ops.length == 0) {
            throw ExceptionFactory.makeWebServiceException((String)("No operation found.  WSDL Operation name: " + mc.getOperationName()));
        }
        if (ops.length > 1) {
            throw ExceptionFactory.makeWebServiceException((String)("More than one operation found. Overloaded WSDL operations are not supported.  WSDL Operation name: " + mc.getOperationName()));
        }
        OperationDescription op = ops[0];
        return op;
    }

    private EndpointDescription getEndpointDescription(org.apache.axis2.jaxws.core.MessageContext mc) {
        AxisService axisSvc = mc.getAxisMessageContext().getAxisService();
        Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        EndpointDescription ed = (EndpointDescription)param.getValue();
        return ed;
    }

    private Method getProviderMethod() {
        try {
            return this.serviceImplClass.getMethod("invoke", this.getProviderType());
        }
        catch (NoSuchMethodException e) {
            throw ExceptionFactory.makeWebServiceException((String)"Could not get Provider.invoke() method");
        }
    }

    private Class<?> getProviderType() {
        Type[] giTypes;
        Class providerType = null;
        for (Type giType : giTypes = this.serviceImplClass.getGenericInterfaces()) {
            ParameterizedType paramType = null;
            try {
                paramType = (ParameterizedType)giType;
            }
            catch (ClassCastException e) {
                throw ExceptionFactory.makeWebServiceException((String)"Provider based SEI Class has to implement javax.xml.ws.Provider as javax.xml.ws.Provider<String>, javax.xml.ws.Provider<SOAPMessage>, javax.xml.ws.Provider<Source> or javax.xml.ws.Provider<JAXBContext>");
            }
            Class interfaceName = (Class)paramType.getRawType();
            if (interfaceName != Provider.class) continue;
            if (paramType.getActualTypeArguments().length > 1) {
                throw ExceptionFactory.makeWebServiceException((String)"Provider cannot have more than one Generic Types defined as Per JAX-WS Specification");
            }
            providerType = (Class)paramType.getActualTypeArguments()[0];
        }
        return providerType;
    }
}

