/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.lib;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.filter.api.FieldOperand;

public class InCollection
extends BasicBinaryOperator {
    private PType elemType;

    public InCollection(FieldOperand left, Operand right, PType elemType) {
        super(PTypeSpace.BOOLEAN, left, right);
        this.elemType = elemType;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((InCollection)clone).elemType = this.elemType;
        return clone;
    }

    public PType getElemType() {
        return this.elemType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        try {
            this.expressions[0].evaluate(pos, o);
            Collection c = null;
            if (this.expressions[1] instanceof ParameterOperand) {
                int i;
                String pn = ((ParameterOperand)this.expressions[1]).getName();
                if (pos == null || pos.length == 0) {
                    throw new ExpressionException("No Parameter");
                }
                for (i = 0; i < pos.length && !pn.equals(pos[i].getName()); ++i) {
                }
                if (i >= pos.length) throw new ExpressionException("Parameter " + pn + " not found");
                c = (Collection)pos[i].getObject();
            } else {
                c = (Collection)((Operand)this.expressions[1]).getObject();
            }
            Iterator it = c.iterator();
            boolean in = false;
            Object obj = ((FieldOperand)this.expressions[0]).getObject();
            while (it.hasNext() && !in) {
                in = it.next().equals(obj);
            }
            this.result.setValue(in);
            return this.result;
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Unevaluable Expression: Not compiled");
        }
    }

    public Operand compileExpression() throws TypingException, MalformedExpressionException {
        if (this.expressions[0] == null || this.expressions[0] == null) {
            throw new MalformedExpressionException("null children value");
        }
        this.result = new BasicVariableOperand(this.type);
        this.verified = true;
        return this.result;
    }

    public String getOperatorString() {
        return "IN";
    }
}

