/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.jacorb.config.Configuration;
import org.jacorb.config.JacORBLogFormatter;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.util.ObjectUtil;

public class JdkLoggingInitializer
extends LoggingInitializer {
    private boolean usingJdkLogging() {
        try {
            Class clazz = ObjectUtil.classForName("org.jacorb.slf4j.impl.JDK14LoggerAdapter");
            return clazz != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Level toJdkLogLevel(String string) {
        if (string == null || string.length() == 0) {
            return Level.INFO;
        }
        try {
            int n = Integer.parseInt(string.trim());
            switch (n) {
                case 0: {
                    return Level.OFF;
                }
                case 1: {
                    return Level.SEVERE;
                }
                case 2: {
                    return Level.WARNING;
                }
                default: {
                    return Level.INFO;
                }
                case 4: 
            }
            return Level.FINEST;
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(numberFormatException);
        }
    }

    public void init(Configuration configuration) {
        if (!this.usingJdkLogging()) {
            return;
        }
        String string = configuration.getAttribute("jacorb.log.default.verbosity", null);
        String string2 = configuration.getAttribute("jacorb.logfile", null);
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0) {
            Logger logger = Logger.getLogger("jacorb");
            logger.setUseParentHandlers(false);
            logger.setLevel(this.toJdkLogLevel(string));
            StreamHandler streamHandler = new ConsoleHandler();
            if (string2 != null && string2.length() > 0) {
                try {
                    streamHandler = new FileHandler(this.substituteImplname(string2, configuration), configuration.getAttributeAsBoolean("jacorb.logfile.append", false));
                }
                catch (IOException iOException) {
                    System.err.println("could not write log file");
                }
            }
            streamHandler.setLevel(this.toJdkLogLevel(string));
            streamHandler.setFormatter(new JacORBLogFormatter());
            logger.addHandler(streamHandler);
        }
    }
}

