/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.slf4j.Logger;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;

public class ExceptionHolderImpl
extends ExceptionHolder
implements Configurable {
    private Logger logger = null;

    public ExceptionHolderImpl() {
    }

    public ExceptionHolderImpl(ReplyInputStream replyInputStream) {
        this();
        int n = replyInputStream.getStatus().value();
        if (n == 1) {
            this.is_system_exception = false;
        } else if (n == 2) {
            this.is_system_exception = true;
        } else {
            throw new BAD_PARAM("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = replyInputStream.littleEndian;
        this.marshaled_exception = replyInputStream.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionHolderImpl(SystemException systemException) {
        this();
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            SystemExceptionHelper.write(cDROutputStream, systemException);
            this.marshaled_exception = cDROutputStream.getBufferCopy();
        }
        finally {
            cDROutputStream.close();
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("jacorb.orb.exc_holder");
    }

    public void raise_exception() throws UserException {
        CDRInputStream cDRInputStream = new CDRInputStream(this.marshaled_exception, this.byte_order);
        try {
            if (this.is_system_exception) {
                throw SystemExceptionHelper.read(cDRInputStream);
            }
            cDRInputStream.mark(0);
            String string = cDRInputStream.read_string();
            try {
                cDRInputStream.reset();
            }
            catch (IOException iOException) {
                this.logger.warn("Unexpected IOException: ", iOException);
            }
            UserException userException = null;
            try {
                userException = this.exceptionFromHelper(string, cDRInputStream);
            }
            catch (Exception exception) {
                throw new UnknownUserException();
            }
            throw userException;
        }
        catch (Throwable throwable) {
            cDRInputStream.close();
            throw throwable;
        }
    }

    public void raise_exception_with_list(ExceptionList exceptionList) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            stringBuffer.append(this.marshaled_exception[i]);
            stringBuffer.append('(');
            stringBuffer.append((char)this.marshaled_exception[i]);
            stringBuffer.append(")  ");
        }
        return stringBuffer.toString();
    }

    public UserException exceptionFromHelper(String string, InputStream inputStream) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String string2 = RepositoryID.className(string, "Helper", null);
        Class clazz = ObjectUtil.classForName(string2);
        Method method = clazz.getMethod("read", ObjectUtil.classForName("org.omg.CORBA.portable.InputStream"));
        Object object = method.invoke(null, inputStream);
        return (UserException)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] marshal() {
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            cDROutputStream.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
            byte[] byArray = cDROutputStream.getBufferCopy();
            return byArray;
        }
        finally {
            cDROutputStream.close();
        }
    }
}

