/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.factory.AbstractSocketFactory;

public class FixedAddressSocketFactory
extends AbstractSocketFactory {
    private InetAddress localEndpoint;

    public Socket createSocket(String string, int n) throws IOException {
        if (this.localEndpoint != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Will create client socket bound to endpoint " + this.localEndpoint);
            }
            return new Socket(string, n, this.localEndpoint, 0);
        }
        return new Socket(string, n);
    }

    protected Socket doCreateSocket(String string, int n, int n2) throws IOException {
        Socket socket = new Socket();
        if (this.localEndpoint != null) {
            socket.bind(new InetSocketAddress(this.localEndpoint, 0));
        }
        socket.connect(new InetSocketAddress(string, n), n2);
        return socket;
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        block3: {
            super.configure(configuration);
            String string = configuration.getAttribute("OAIAddr", "");
            if (string.length() > 0) {
                try {
                    this.localEndpoint = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Failed to create InetAddress from property OAIAddr >" + string + "<", unknownHostException);
                }
            }
        }
    }
}

