/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.slf4j.Logger;

public class RPPoolManagerFactory {
    private final ORB orb;
    private final Logger logger;
    private final Configuration configuration;
    private final int threadPoolMin;
    private final int threadPoolMax;
    private final FactoryDelegate delegate;

    public RPPoolManagerFactory(ORB oRB) throws ConfigurationException {
        this.orb = oRB;
        this.configuration = oRB.getConfiguration();
        this.logger = this.configuration.getLogger("jacorb.poa.controller");
        this.threadPoolMin = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_min", 5);
        if (this.threadPoolMin < 1) {
            throw new ConfigurationException("jacorb.poa.thread_pool_min must be >= 1");
        }
        this.threadPoolMax = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
        if (this.threadPoolMax < this.threadPoolMin) {
            throw new ConfigurationException("jacorb.poa.thread_pool_max must be >= " + this.threadPoolMin + "(jacorb.poa.thread_pool_min)");
        }
        boolean bl = this.configuration.getAttributeAsBoolean("jacorb.poa.thread_pool_shared", false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RequestProcessorPoolFactory settings: thread_pool_min=" + this.threadPoolMin + " thread_pool_max=" + this.threadPoolMax + " thread_pool_shared=" + bl);
        }
        this.delegate = bl ? new SharedPoolFactory() : new DefaultPoolFactory();
    }

    public void destroy() {
        this.delegate.destroy();
    }

    public RPPoolManager newRPPoolManager(boolean bl) {
        if (bl) {
            return new RPPoolManager(this.orb.getPOACurrent(), 1, 1, this.logger, this.configuration){

                void destroy() {
                    this.destroy(true);
                }

                protected void warnPoolIsEmpty() {
                }
            };
        }
        return this.delegate.newRPPoolManager();
    }

    private class DefaultPoolFactory
    implements FactoryDelegate {
        private DefaultPoolFactory() {
        }

        public RPPoolManager newRPPoolManager() {
            return new RPPoolManager(RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){

                void destroy() {
                    this.destroy(true);
                }
            };
        }

        public void destroy() {
        }
    }

    private class SharedPoolFactory
    implements FactoryDelegate {
        private final RPPoolManager sharedInstance;

        private SharedPoolFactory() {
            this.sharedInstance = new RPPoolManager(RPPoolManagerFactory.this.orb.getPOACurrent(), RPPoolManagerFactory.this.threadPoolMin, RPPoolManagerFactory.this.threadPoolMax, RPPoolManagerFactory.this.logger, RPPoolManagerFactory.this.configuration){

                void destroy() {
                }
            };
        }

        public RPPoolManager newRPPoolManager() {
            return this.sharedInstance;
        }

        public void destroy() {
            this.sharedInstance.destroy(true);
        }
    }

    private static interface FactoryDelegate {
        public RPPoolManager newRPPoolManager();

        public void destroy();
    }
}

