/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.PacketTooBigException;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.Repository;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.dbcp.BasicDataSource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class MySqlDBRepository
implements Repository {
    String driver = System.getProperty("DBDriver", "org.gjt.mm.mysql.Driver");
    String connurl = System.getProperty("ConnURL", "jdbc:mysql://localhost:3306/mysql");
    String user = System.getProperty("DBUser", "root");
    String pass = System.getProperty("DBPass", "");
    BasicDataSource ds = null;
    boolean reconnectLoop = false;
    public static Logger logger = Debug.getLogger((String)"fr.dyade.aaa.util.MySqlDBRepository");
    File dir = null;
    private int nbsaved = 0;
    private int nbdeleted = 0;
    private int baddeleted = 0;
    private int nbloaded = 0;
    Connection conn = null;
    PreparedStatement insertStmt = null;
    PreparedStatement updateStmt = null;
    PreparedStatement deleteStmt = null;

    public int getNbSavedObjects() {
        return this.nbsaved;
    }

    public int getNbDeletedObjects() {
        return this.nbdeleted;
    }

    public int getNbBadDeletedObjects() {
        return this.baddeleted;
    }

    public int getNbLoadedObjects() {
        return this.nbloaded;
    }

    public void init(File dir) throws IOException {
        this.dir = dir;
        try {
            Class.forName(this.driver).newInstance();
            Properties props = new Properties();
            props.put("user", this.user);
            props.put("password", this.pass);
            this.conn = this.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (IllegalAccessException exc) {
            throw new IOException(exc.getMessage());
        }
        catch (ClassNotFoundException exc) {
            throw new IOException(exc.getMessage());
        }
        catch (InstantiationException exc) {
            throw new IOException(exc.getMessage());
        }
        catch (SQLException sqle) {
            throw new IOException(sqle.getMessage());
        }
        try {
            Statement s = this.conn.createStatement();
            s.execute("CREATE TABLE JoramDB (name VARCHAR(256), content longblob, primary key(name))");
            s.close();
            this.conn.commit();
        }
        catch (SQLException sqle) {
            String exceptionString = sqle.toString();
            if (exceptionString.indexOf("CREATE command denied") == -1) {
                sqle.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.insertStmt = this.conn.prepareStatement("INSERT INTO JoramDB VALUES (?, ?)");
            this.updateStmt = this.conn.prepareStatement("UPDATE JoramDB SET content=? WHERE name=?");
            this.deleteStmt = this.conn.prepareStatement("DELETE FROM JoramDB WHERE name=?");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] list(String prefix) throws IOException {
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM JoramDB WHERE name LIKE '" + prefix + "%'");
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            rs.close();
            s.close();
            String[] result = new String[v.size()];
            result = v.toArray(result);
            return result;
        }
        catch (SQLException sqle) {
            if (sqle instanceof CommunicationsException && !this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at list, Reconnecting");
                this.reconnection();
                this.reconnectLoop = true;
                String[] result = this.list(prefix);
                this.reconnectLoop = false;
                return result;
            }
            if (this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at list");
            }
            logger.log(BasicLevel.WARN, (Object)("list, problem list " + prefix));
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("list, problem list " + prefix + " in e with " + e.getMessage()));
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void save(String dirName, String name, byte[] content) throws IOException {
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        boolean requireReconnect = false;
        try {
            this.insertStmt.setString(1, fname);
            this.insertStmt.setBytes(2, content);
            this.insertStmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                this.updateStmt.setBytes(1, content);
                this.updateStmt.setString(2, fname);
                this.updateStmt.executeUpdate();
            }
            catch (PacketTooBigException ptbe) {
                System.err.println("MySqlDBRepository.save - was trying to save\ndirName: " + dirName + "\nname: " + name);
                ptbe.printStackTrace();
            }
            catch (SQLException sqle) {
                if (sqle instanceof CommunicationsException && !this.reconnectLoop) {
                    logger.log(BasicLevel.WARN, (Object)"Database CommunicationsException problem at save, requires Reconnection");
                    requireReconnect = true;
                } else {
                    if (this.reconnectLoop) {
                        logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at save. Still have CommunicationsException");
                    }
                    logger.log(BasicLevel.WARN, (Object)("save, CommunicationsException problem saving " + name));
                    sqle.printStackTrace();
                }
            }
            catch (NullPointerException ne) {
                if (!this.reconnectLoop) {
                    logger.log(BasicLevel.WARN, (Object)"Database NullPointerException problem at save, requires Reconnection");
                    requireReconnect = true;
                } else {
                    if (this.reconnectLoop) {
                        logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at save. Still have NullPointerException");
                    }
                    logger.log(BasicLevel.WARN, (Object)("save, NullPointerException problem saving " + name));
                    ne.printStackTrace();
                }
            }
            catch (Exception e2) {
                logger.log(BasicLevel.WARN, (Object)("save, problem saving " + name + " in e2 with " + e2.getMessage()));
                e2.printStackTrace();
            }
        }
        if (requireReconnect) {
            logger.log(BasicLevel.WARN, (Object)"Database problem at save, Reconnecting");
            this.reconnection();
            this.reconnectLoop = true;
            this.save(dirName, name, content);
            this.reconnectLoop = false;
        }
        ++this.nbsaved;
    }

    public Object loadobj(String dirName, String name) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"loadobj, b4 load call");
        }
        byte[] content = this.load(dirName, name);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"loadobj, after load call");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Object obj;
            Object object = obj = ois.readObject();
            return object;
        }
        catch (Exception e) {
            String exceptionString = e.toString();
            if (exceptionString.indexOf("KNOWN PROBLEM") == -1) {
                e.printStackTrace();
            }
            throw new IOException(e.getMessage());
        }
        finally {
            ois.close();
            bis.close();
        }
    }

    public byte[] load(String dirName, String name) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"load called");
        }
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        try {
            Statement s = this.conn.createStatement();
            ResultSet rs = s.executeQuery("SELECT content FROM JoramDB WHERE name='" + fname + "'");
            if (!rs.next()) {
                throw new FileNotFoundException("Cannot find object in JoramDB " + ("serverCounter".equals(fname) ? "[KNOWN PROBLEM] " : "") + fname);
            }
            byte[] content = rs.getBytes(1);
            rs.close();
            s.close();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"load, after database call");
            }
            ++this.nbloaded;
            return content;
        }
        catch (SQLException sqle) {
            if (sqle instanceof CommunicationsException && !this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at load, Reconnecting");
                this.reconnection();
                this.reconnectLoop = true;
                byte[] content = this.load(dirName, name);
                this.reconnectLoop = false;
                return content;
            }
            if (this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at load");
            }
            logger.log(BasicLevel.WARN, (Object)("load, problem load " + name));
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            String exceptionString = e.toString();
            if (exceptionString.indexOf("KNOWN PROBLEM") == -1) {
                logger.log(BasicLevel.WARN, (Object)("load, problem load " + name + " in e with " + e.getMessage()));
                e.printStackTrace();
            }
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public void delete(String dirName, String name) throws IOException {
        String fname = null;
        fname = dirName == null ? name : new StringBuffer(dirName).append('/').append(name).toString();
        int nb = 0;
        try {
            Statement s = this.conn.createStatement();
            nb = s.executeUpdate("DELETE FROM JoramDB WHERE name='" + fname + "'");
        }
        catch (SQLException sqle) {
            if (sqle instanceof CommunicationsException && !this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at delete, Reconnecting");
                this.reconnection();
                this.reconnectLoop = true;
                this.delete(dirName, name);
                this.reconnectLoop = false;
            }
            if (this.reconnectLoop) {
                logger.log(BasicLevel.WARN, (Object)"Database reconnection problem at delete");
            }
            logger.log(BasicLevel.WARN, (Object)("delete, problem delete " + name));
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("delete, problem delete " + name + " in e with " + e.getMessage()));
            e.printStackTrace();
        }
        if (nb != 1) {
            ++this.baddeleted;
        }
        ++this.nbdeleted;
    }

    public void commit() throws IOException {
        try {
            this.conn.commit();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() throws IOException {
        try {
            this.conn.close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ds != null) {
            try {
                this.ds.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        this.ds = new BasicDataSource();
        this.ds.setDriverClassName(this.driver);
        this.ds.setUsername(this.user);
        this.ds.setPassword(this.pass);
        this.ds.setUrl(this.connurl);
        return this.ds.getConnection();
    }

    private void closeConnection() {
        logger.log(BasicLevel.WARN, (Object)"closeConnection in progress");
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.log(BasicLevel.WARN, (Object)"closeConnection success");
        this.ds = null;
    }

    private void reconnection() throws IOException {
        logger.log(BasicLevel.WARN, (Object)"reconnection in progress - starting");
        try {
            if (this.ds != null) {
                this.closeConnection();
            }
            logger.log(BasicLevel.WARN, (Object)"reconnection in progress - old connection closed");
            this.conn = this.getConnection();
            logger.log(BasicLevel.WARN, (Object)"reconnection in progress - getConnection success");
            this.conn.setAutoCommit(false);
            this.insertStmt = this.conn.prepareStatement("INSERT INTO JoramDB VALUES (?, ?)");
            this.updateStmt = this.conn.prepareStatement("UPDATE JoramDB SET content=? WHERE name=?");
            this.deleteStmt = this.conn.prepareStatement("DELETE FROM JoramDB WHERE name=?");
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            throw new IOException(sqle.getMessage());
        }
        logger.log(BasicLevel.WARN, (Object)"Database reconnection success");
    }
}

