/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.resource.internal.SQLManager;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;

public class SQLConnectionInvocationHandler
implements InvocationHandler {
    private static final int PROXY_FIXED_ARGS = 3;
    private Object connection = null;
    private SQLManager conman = null;
    private ManagedConnectionInfo mci = null;
    private String user = null;
    private Logger trace = null;
    private boolean invalid = false;
    private boolean supportsPreparedCache = true;

    public SQLConnectionInvocationHandler(Object pConn, ManagedConnectionInfo pMci, SQLManager pConman, Logger pTrace) throws Exception {
        this.connection = pConn;
        this.mci = pMci;
        this.conman = pConman;
        this.trace = pTrace;
        this.user = this.mci.mc.getMetaData().getUserName();
    }

    public static Object createSQLWrapper(Object pConn, ManagedConnectionInfo pMci, SQLManager pConman, Logger pTrace) throws Exception {
        Class<?> class1 = pConn.getClass();
        Class[] aclass = SQLConnectionInvocationHandler.buildInterfaces(class1);
        return Proxy.newProxyInstance(class1.getClassLoader(), aclass, (InvocationHandler)new SQLConnectionInvocationHandler(pConn, pMci, pConman, pTrace));
    }

    public Object invoke(Object obj, Method method, Object[] aobj) throws Throwable {
        Object retObj = null;
        if (method.getName().compareTo("prepareStatement") == 0) {
            retObj = this.prepareStatement(method.getParameterTypes(), aobj);
            if (retObj == null) {
                retObj = method.invoke(this.connection, aobj);
            }
        } else {
            if (method.getName().compareTo("close") == 0) {
                this.invalid = true;
            } else {
                if (method.getName().compareTo("toString") == 0) {
                    return this.connection.toString();
                }
                if (method.getName().compareTo("commit") == 0) {
                    if (this.trace.isLoggable(BasicLevel.DEBUG)) {
                        this.trace.log(BasicLevel.DEBUG, (Object)("" + this));
                    }
                } else {
                    this.checkIfValid();
                }
            }
            retObj = method.invoke(this.connection, aobj);
        }
        return retObj;
    }

    public Object prepareStatement(Class[] pTypes, Object[] pValues) throws Exception {
        this.checkIfValid();
        if (this.supportsPreparedCache) {
            try {
                Class[] mTypes = new Class[3 + pTypes.length];
                Object[] mValues = new Object[3 + pValues.length];
                mTypes[0] = ManagedConnectionInfo.class;
                mTypes[1] = Object.class;
                mTypes[2] = String.class;
                mValues[0] = this.mci;
                mValues[1] = this.connection;
                mValues[2] = this.user;
                for (int i = 0; i < pTypes.length; ++i) {
                    mTypes[3 + i] = pTypes[i];
                    mValues[3 + i] = pValues[i];
                }
                Method meth1 = this.conman.getClass().getMethod("getPStatement", mTypes);
                return meth1.invoke((Object)this.conman, mValues);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String toString() {
        return this.connection.toString();
    }

    private void checkIfValid() throws SQLException {
        if (this.invalid) {
            throw new SQLException("Connection is closed");
        }
    }

    private static Class[] buildInterfaces(Class class1) {
        ArrayList arlist = new ArrayList();
        SQLConnectionInvocationHandler.addToList(class1, arlist);
        Class[] aclass = new Class[arlist.size()];
        return arlist.toArray(aclass);
    }

    private static void addToList(Class cls, List lst) {
        Class<?>[] aclass = cls.getInterfaces();
        for (int i = 0; i < aclass.length; ++i) {
            if (!lst.contains(aclass[i])) {
                lst.add(aclass[i]);
            }
            SQLConnectionInvocationHandler.addToList(aclass[i], lst);
        }
        Class class2 = cls.getSuperclass();
        if (class2 != null) {
            SQLConnectionInvocationHandler.addToList(class2, lst);
        }
    }
}

