/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.sql.cache;

import java.util.Arrays;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PreparedStatementMapCacheKey {
    private String user = null;
    private String sql = null;
    private int hashCode;
    private int resultSetType = -1;
    private int resultSetConcurrency = -1;
    private int resultSetHoldability = -1;
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes = null;
    private String[] columnNames = null;
    private final Logger logger;

    public PreparedStatementMapCacheKey(String user, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, int hashcode, Logger logger) {
        this.user = user;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = columnIndexes;
        this.columnNames = columnNames;
        this.hashCode = hashcode;
        this.logger = logger;
    }

    public boolean equals(Object key) {
        if (key == null) {
            return false;
        }
        if (this.hashCode != key.hashCode()) {
            return false;
        }
        if (!(key instanceof PreparedStatementMapCacheKey)) {
            return false;
        }
        PreparedStatementMapCacheKey pstmtKey = (PreparedStatementMapCacheKey)key;
        if (this.sql == null && pstmtKey.sql != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt sql: " + pstmtKey.sql + " not equal to " + this.sql));
            }
            return false;
        }
        if (this.sql != null && !this.sql.equals(pstmtKey.sql)) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt sql: " + pstmtKey.sql + " not equal to " + this.sql));
            }
            return false;
        }
        if (this.user == null && pstmtKey.user != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt user: " + pstmtKey.user + " not equal to " + this.user));
            }
            return false;
        }
        if (this.user != null && !this.user.equals(pstmtKey.user)) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt user: " + pstmtKey.user + " not equal to " + this.user));
            }
            return false;
        }
        if (this.resultSetType != pstmtKey.resultSetType) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt resultSetType: " + pstmtKey.resultSetType + " not equal to " + this.resultSetType));
            }
            return false;
        }
        if (this.resultSetConcurrency != pstmtKey.resultSetConcurrency) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt resultSetConcurrency: " + pstmtKey.resultSetConcurrency + " not equal to " + this.resultSetConcurrency));
            }
            return false;
        }
        if (this.resultSetHoldability != pstmtKey.resultSetHoldability) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt resultSetHoldability: " + pstmtKey.resultSetHoldability + " not equal to " + this.resultSetHoldability));
            }
            return false;
        }
        if (this.autoGeneratedKeys != pstmtKey.autoGeneratedKeys) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt autoGeneratedKeys: " + pstmtKey.autoGeneratedKeys + " not equal to " + this.autoGeneratedKeys));
            }
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, pstmtKey.columnIndexes)) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt columnIndexes: " + pstmtKey.columnIndexes + " not equal to " + this.columnIndexes));
            }
            return false;
        }
        if (!Arrays.equals(this.columnNames, pstmtKey.columnNames)) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Stmt columnNames: " + pstmtKey.columnNames + " not equal to " + this.columnNames));
            }
            return false;
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Stmt found at " + this));
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

