/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansMDBLifeCycle;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansSFSBLifeCycle;
import org.ow2.easybeans.api.bean.lifecycle.EasyBeansSLSBLifeCycle;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.asm.Label;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Opcodes;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.DefinedClass;
import org.ow2.easybeans.enhancer.bean.BeanClassAdapter;
import org.ow2.easybeans.enhancer.injection.InjectionClassAdapter;
import org.ow2.easybeans.enhancer.interceptors.EasyBeansInvocationContextGenerator;
import org.ow2.easybeans.enhancer.interceptors.InterceptorManagerGenerator;
import org.ow2.easybeans.enhancer.interceptors.MethodHelper;
import org.ow2.easybeans.enhancer.lib.AnnotationRecorder;
import org.ow2.easybeans.enhancer.lib.MethodAdapterWithAnnotationRecorder;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.easybeans.enhancer.lib.ParameterAnnotationRecorder;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassAdapter
extends ClassAdapter
implements Opcodes {
    public static final String EASYBEANS_SHARED_CLASS_FLAG = "easybeans.sharedclass";
    private EasyBeansEjbJarClassMetadata classAnnotationMetadata;
    private List<JMethod> renamedMethods = null;
    private List<DefinedClass> definedClasses = null;
    private List<InterceptorType> generatedTypes = null;
    private List<String> beanInterceptors = null;
    private boolean addInterface = true;
    private Map<String, List<AnnotationRecorder>> annotationsOfMethod = null;
    private Map<String, List<ParameterAnnotationRecorder>> parametersAnnotationsOfMethod = null;

    public InterceptorClassAdapter(EasyBeansEjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv) {
        this(classAnnotationMetadata, cv, false);
        this.beanInterceptors = new ArrayList<String>();
        this.annotationsOfMethod = new HashMap<String, List<AnnotationRecorder>>();
        this.parametersAnnotationsOfMethod = new HashMap<String, List<ParameterAnnotationRecorder>>();
    }

    public InterceptorClassAdapter(EasyBeansEjbJarClassMetadata classAnnotationMetadata, ClassVisitor cv, boolean addInterface) {
        super(cv);
        this.classAnnotationMetadata = classAnnotationMetadata;
        this.renamedMethods = new ArrayList<JMethod>();
        this.definedClasses = new ArrayList<DefinedClass>();
        this.addInterface = addInterface;
        this.generatedTypes = new ArrayList<InterceptorType>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] newInterfaces = null;
        if (this.classAnnotationMetadata.isBean() && this.addInterface) {
            newInterfaces = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            int indexElement = newInterfaces.length - 1;
            if (this.classAnnotationMetadata.isStateless()) {
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansSLSBLifeCycle.class);
            } else if (this.classAnnotationMetadata.isStateful()) {
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansSFSBLifeCycle.class);
            } else {
                if (!this.classAnnotationMetadata.isMdb()) throw new IllegalStateException("Bean '" + this.classAnnotationMetadata.getClassName() + "' not SLSB, SFSB or MDB");
                newInterfaces[indexElement] = Type.getInternalName(EasyBeansMDBLifeCycle.class);
            }
        } else {
            newInterfaces = interfaces;
        }
        super.visit(version, access, name, signature, superName, newInterfaces);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        String newName = name;
        int newAccess = access;
        if (this.isInterceptedMethod(jMethod) && this.classAnnotationMetadata.isBean()) {
            this.renamedMethods.add(jMethod);
            newName = MethodRenamer.encode(name);
        }
        if (!this.isDependencyInjectionMethod(jMethod) && !this.isInjectedMethod(jMethod) && this.isInterceptorMethod(jMethod)) {
            newAccess = 1;
        }
        if (this.classAnnotationMetadata.isBean() && (this.isInterceptedMethod(jMethod) || this.isInterceptorMethod(jMethod))) {
            MethodAdapterWithAnnotationRecorder methodAdapter = new MethodAdapterWithAnnotationRecorder(super.visitMethod(newAccess, newName, desc, signature, exceptions));
            this.annotationsOfMethod.put(name + desc, methodAdapter.getAnnotationRecorders());
            this.parametersAnnotationsOfMethod.put(name + desc, methodAdapter.getParameterAnnotationRecorders());
            return methodAdapter;
        }
        return super.visitMethod(newAccess, newName, desc, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.classAnnotationMetadata.isBean()) {
            EasyBeansEjbJarMethodMetadata posConsMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.POST_CONSTRUCT);
            EasyBeansEjbJarMethodMetadata preDesMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.PRE_DESTROY);
            EasyBeansEjbJarMethodMetadata postActMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.POST_ACTIVATE);
            EasyBeansEjbJarMethodMetadata prePassMetaData = this.generateBeanLifeCycleMethod(this.classAnnotationMetadata, InterceptorType.PRE_PASSIVATE);
            this.generateClass(new EasyBeansEjbJarMethodMetadata(InjectionClassAdapter.INJECTED_JMETHOD, this.classAnnotationMetadata), InterceptorType.DEP_INJECT);
            EasyBeansEjbJarMethodMetadata timerMethodAnnotationMetadata = null;
            for (EasyBeansEjbJarMethodMetadata m : this.classAnnotationMetadata.getMethodMetadataCollection()) {
                if (!m.isTimeout()) continue;
                timerMethodAnnotationMetadata = (EasyBeansEjbJarMethodMetadata)m.clone();
                timerMethodAnnotationMetadata.setJMethod(BeanClassAdapter.TIMER_JMETHOD);
                timerMethodAnnotationMetadata.setClassMetadata((IClassMetadata)this.classAnnotationMetadata);
                timerMethodAnnotationMetadata.setInherited(false, null);
                break;
            }
            if (timerMethodAnnotationMetadata == null) {
                timerMethodAnnotationMetadata = new EasyBeansEjbJarMethodMetadata(BeanClassAdapter.TIMER_JMETHOD, this.classAnnotationMetadata);
            }
            this.generateClass(timerMethodAnnotationMetadata, InterceptorType.TIMED_OBJECT);
            for (EasyBeansEjbJarMethodMetadata method : this.classAnnotationMetadata.getMethodMetadataCollection()) {
                if (!method.isBusinessMethod() || method.isIgnored()) continue;
                this.generateClass(method, InterceptorType.AROUND_INVOKE);
                if (this.renamedMethods.contains(method.getJMethod())) continue;
                this.generateCallSuperEncodedMethod(method);
            }
            this.generateClass(posConsMetaData, InterceptorType.POST_CONSTRUCT);
            this.generateClass(preDesMetaData, InterceptorType.PRE_DESTROY);
            this.generateClass(prePassMetaData, InterceptorType.PRE_PASSIVATE);
            this.generateClass(postActMetaData, InterceptorType.POST_ACTIVATE);
            String generatedClName = this.classAnnotationMetadata.getClassName() + "InterceptorManager";
            InterceptorManagerGenerator interceptorManagerGenerator = new InterceptorManagerGenerator((EjbJarArchiveMetadata)this.classAnnotationMetadata.getEjbJarDeployableMetadata(), generatedClName, this.beanInterceptors);
            interceptorManagerGenerator.generate();
            DefinedClass dc = new DefinedClass(generatedClName.replace("/", "."), interceptorManagerGenerator.getBytes());
            this.definedClasses.add(dc);
        }
    }

    private void generateCallToInvocationContext(EasyBeansEjbJarMethodMetadata method, EasyBeansInvocationContextGenerator genInvCtx, InterceptorType interceptorType) {
        Type returnType;
        Type[] args;
        String generatedMethodName = null;
        switch (interceptorType) {
            case AROUND_INVOKE: {
                generatedMethodName = method.getMethodName();
                break;
            }
            case DEP_INJECT: 
            case TIMED_OBJECT: {
                generatedMethodName = MethodRenamer.decode(method.getMethodName());
                break;
            }
            case POST_CONSTRUCT: {
                generatedMethodName = "postConstructEasyBeansLifeCycle";
                break;
            }
            case PRE_DESTROY: {
                generatedMethodName = "preDestroyEasyBeansLifeCycle";
                break;
            }
            case PRE_PASSIVATE: {
                generatedMethodName = "prePassivateEasyBeansLifeCycle";
                break;
            }
            case POST_ACTIVATE: {
                generatedMethodName = "postActivateEasyBeansLifeCycle";
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for method '" + method.getMethodName() + "'");
            }
        }
        if (generatedMethodName == null) {
            throw new RuntimeException("No generated method name found for method '" + method.getMethodName() + "'");
        }
        MethodVisitor mv = this.cv.visitMethod(1, generatedMethodName, method.getJMethod().getDescriptor(), null, method.getJMethod().getExceptions());
        if (this.renamedMethods.contains(method.getJMethod())) {
            List<ParameterAnnotationRecorder> parameterAnnotationRecorders;
            String nameDesc = MethodRenamer.tryDecode(generatedMethodName) + method.getJMethod().getDescriptor();
            List<AnnotationRecorder> annotationRecorders = this.annotationsOfMethod.get(nameDesc);
            if (annotationRecorders != null) {
                for (AnnotationRecorder annotationRecorder : annotationRecorders) {
                    annotationRecorder.replay(mv);
                }
            }
            if ((parameterAnnotationRecorders = this.parametersAnnotationsOfMethod.get(nameDesc)) != null) {
                for (ParameterAnnotationRecorder parameterAnnotationRecorder : parameterAnnotationRecorders) {
                    parameterAnnotationRecorder.replay(mv);
                }
            }
        } else {
            CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        }
        mv.visitCode();
        if (Boolean.getBoolean(EASYBEANS_SHARED_CLASS_FLAG)) {
            Label easyBeansFactoryNotNullLabel = new Label();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansFactory", "()Lorg/ow2/easybeans/api/Factory;");
            mv.visitJumpInsn(199, easyBeansFactoryNotNullLabel);
            args = Type.getArgumentTypes(method.getJMethod().getDescriptor());
            mv.visitVarInsn(25, 0);
            int methodArg = 1;
            for (Type type : args) {
                int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
                mv.visitVarInsn(opCode, methodArg);
                if (opCode == 22 || opCode == 24) {
                    ++methodArg;
                }
                ++methodArg;
            }
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), MethodRenamer.encode(method.getMethodName()), method.getJMethod().getDescriptor());
            returnType = Type.getReturnType(method.getJMethod().getDescriptor());
            CommonClassGenerator.addReturnType(returnType, mv);
            mv.visitLabel(easyBeansFactoryNotNullLabel);
        }
        if (interceptorType == InterceptorType.AROUND_INVOKE || interceptorType == InterceptorType.POST_CONSTRUCT || interceptorType == InterceptorType.PRE_DESTROY) {
            int block;
            Label tryLabelStart = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitTryCatchBlock(tryLabelStart, l1, l2, "java/lang/Exception");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansInvocationContextFactory", "()Lorg/ow2/easybeans/api/interceptor/EZBInvocationContextFactory;");
            Label labelNoInvocationContextFactory = new Label();
            mv.visitJumpInsn(198, labelNoInvocationContextFactory);
            mv.visitLabel(tryLabelStart);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansInvocationContextFactory", "()Lorg/ow2/easybeans/api/interceptor/EZBInvocationContextFactory;");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansDynamicInterceptorManager", "()Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;");
            mv.visitFieldInsn(178, Type.getInternalName(InterceptorType.class), interceptorType.toString(), "Lorg/ow2/util/ee/metadata/ejbjar/api/InterceptorType;");
            mv.visitMethodInsn(182, Type.getInternalName(InterceptorType.class), "toString", "()Ljava/lang/String;");
            mv.visitLdcInsn(MethodHelper.getSignature(method));
            Type[] args2 = Type.getArgumentTypes(method.getJMethod().getDescriptor());
            int methodArg = 1;
            mv.visitIntInsn(16, args2.length);
            mv.visitTypeInsn(189, "java/lang/Object");
            int argCount = 0;
            for (Type type : args2) {
                mv.visitInsn(89);
                mv.visitIntInsn(16, argCount);
                int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
                mv.visitVarInsn(opCode, methodArg);
                if (opCode == 22 || opCode == 24) {
                    ++methodArg;
                }
                ++methodArg;
                CommonClassGenerator.transformPrimitiveIntoObject(type, mv);
                mv.visitInsn(83);
                ++argCount;
            }
            Type returnType2 = Type.getReturnType(method.getJMethod().getDescriptor());
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/interceptor/EZBInvocationContextFactory", "getContext", "(Lorg/ow2/easybeans/api/bean/EasyBeansBean;Lorg/ow2/easybeans/api/interceptor/EZBInterceptorManager;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/ow2/easybeans/api/EasyBeansInvocationContext;");
            mv.visitMethodInsn(185, "org/ow2/easybeans/api/EasyBeansInvocationContext", "proceed", "()Ljava/lang/Object;");
            CommonClassGenerator.transformObjectIntoPrimitive(returnType2, mv);
            mv.visitLabel(l1);
            CommonClassGenerator.addReturnType(returnType2, mv);
            mv.visitLabel(l2);
            boolean methodAlreadyThrowJavaLangException = false;
            String[] methodExceptions = method.getJMethod().getExceptions();
            Label[] catchsLabel = null;
            if (methodExceptions != null) {
                if (Arrays.asList(methodExceptions).contains("java/lang/Exception")) {
                    methodAlreadyThrowJavaLangException = true;
                    catchsLabel = new Label[methodExceptions.length];
                } else {
                    catchsLabel = new Label[methodExceptions.length + 1];
                }
            } else {
                catchsLabel = new Label[1];
            }
            for (int i = 0; i < catchsLabel.length; ++i) {
                catchsLabel[i] = new Label();
            }
            int lastCatchBlockLabel = 0;
            lastCatchBlockLabel = methodAlreadyThrowJavaLangException ? catchsLabel.length : catchsLabel.length - 1;
            for (block = 0; block < lastCatchBlockLabel; ++block) {
                mv.visitLabel(catchsLabel[block]);
                mv.visitVarInsn(58, methodArg);
                mv.visitVarInsn(25, methodArg);
                mv.visitInsn(191);
            }
            if (!methodAlreadyThrowJavaLangException) {
                mv.visitLabel(catchsLabel[lastCatchBlockLabel]);
                mv.visitVarInsn(58, methodArg);
                mv.visitVarInsn(25, methodArg);
                mv.visitTypeInsn(193, "java/lang/RuntimeException");
                Label notInstanceOfRuntimeExceptionLabel = new Label();
                mv.visitJumpInsn(153, notInstanceOfRuntimeExceptionLabel);
                mv.visitVarInsn(25, methodArg);
                mv.visitTypeInsn(192, "java/lang/RuntimeException");
                mv.visitInsn(191);
                mv.visitLabel(notInstanceOfRuntimeExceptionLabel);
                mv.visitTypeInsn(187, "java/lang/RuntimeException");
                mv.visitInsn(89);
                mv.visitVarInsn(25, methodArg);
                mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
                mv.visitInsn(191);
            }
            block = 0;
            if (methodExceptions != null) {
                for (String exception : methodExceptions) {
                    mv.visitTryCatchBlock(tryLabelStart, catchsLabel[0], catchsLabel[block], exception);
                    ++block;
                }
            }
            if (!methodAlreadyThrowJavaLangException) {
                mv.visitTryCatchBlock(tryLabelStart, catchsLabel[0], catchsLabel[lastCatchBlockLabel], "java/lang/Exception");
            }
            mv.visitLabel(labelNoInvocationContextFactory);
        }
        Label tryLabel = new Label();
        mv.visitLabel(tryLabel);
        mv.visitTypeInsn(187, genInvCtx.getGeneratedClassName());
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        args = Type.getArgumentTypes(method.getJMethod().getDescriptor());
        int methodArg = 1;
        for (Type type : args) {
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, methodArg);
            if (opCode == 22 || opCode == 24) {
                ++methodArg;
            }
            ++methodArg;
        }
        returnType = Type.getReturnType(method.getJMethod().getDescriptor());
        String constructorDesc = genInvCtx.getConstructorDesc();
        mv.visitMethodInsn(183, genInvCtx.getGeneratedClassName(), "<init>", constructorDesc);
        mv.visitMethodInsn(182, genInvCtx.getGeneratedClassName(), "proceed", "()Ljava/lang/Object;");
        CommonClassGenerator.transformObjectIntoPrimitive(returnType, mv);
        CommonClassGenerator.addReturnType(returnType, mv);
        boolean methodAlreadyThrowJavaLangException = false;
        String[] methodExceptions = method.getJMethod().getExceptions();
        Label[] catchsLabel = null;
        if (methodExceptions != null) {
            if (Arrays.asList(methodExceptions).contains("java/lang/Exception")) {
                methodAlreadyThrowJavaLangException = true;
                catchsLabel = new Label[methodExceptions.length];
            } else {
                catchsLabel = new Label[methodExceptions.length + 1];
            }
        } else {
            catchsLabel = new Label[1];
        }
        for (int i = 0; i < catchsLabel.length; ++i) {
            catchsLabel[i] = new Label();
        }
        int lastCatchBlockLabel = 0;
        lastCatchBlockLabel = methodAlreadyThrowJavaLangException ? catchsLabel.length : catchsLabel.length - 1;
        for (int block = 0; block < lastCatchBlockLabel; ++block) {
            mv.visitLabel(catchsLabel[block]);
            mv.visitVarInsn(58, methodArg);
            mv.visitVarInsn(25, methodArg);
            mv.visitInsn(191);
        }
        if (!methodAlreadyThrowJavaLangException) {
            mv.visitLabel(catchsLabel[lastCatchBlockLabel]);
            mv.visitVarInsn(58, methodArg);
            mv.visitVarInsn(25, methodArg);
            mv.visitTypeInsn(193, "java/lang/RuntimeException");
            Label notInstanceOfRuntimeExceptionLabel = new Label();
            mv.visitJumpInsn(153, notInstanceOfRuntimeExceptionLabel);
            mv.visitVarInsn(25, methodArg);
            mv.visitTypeInsn(192, "java/lang/RuntimeException");
            mv.visitInsn(191);
            mv.visitLabel(notInstanceOfRuntimeExceptionLabel);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitVarInsn(25, methodArg);
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/Throwable;)V");
            mv.visitInsn(191);
        }
        int block = 0;
        if (methodExceptions != null) {
            for (String exception : methodExceptions) {
                mv.visitTryCatchBlock(tryLabel, catchsLabel[0], catchsLabel[block], exception);
                ++block;
            }
        }
        if (!methodAlreadyThrowJavaLangException) {
            mv.visitTryCatchBlock(tryLabel, catchsLabel[0], catchsLabel[lastCatchBlockLabel], "java/lang/Exception");
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateClass(EasyBeansEjbJarMethodMetadata method, InterceptorType interceptorType) {
        EasyBeansInvocationContextGenerator genInvCtx = new EasyBeansInvocationContextGenerator(method, interceptorType);
        genInvCtx.generate();
        for (IJClassInterceptor interceptor : genInvCtx.getAllInterceptors()) {
            String interceptorClassName = interceptor.getClassName();
            if (interceptorClassName.equals(this.classAnnotationMetadata.getClassName()) || this.beanInterceptors.contains(interceptorClassName)) continue;
            this.beanInterceptors.add(interceptorClassName);
        }
        DefinedClass dc = new DefinedClass(genInvCtx.getGeneratedClassName().replace("/", "."), genInvCtx.getBytes());
        this.definedClasses.add(dc);
        this.generatedTypes.add(interceptorType);
        this.generateCallToInvocationContext(method, genInvCtx, interceptorType);
    }

    private void generateCallSuperEncodedMethod(EasyBeansEjbJarMethodMetadata method) {
        String generatedMethodName = MethodRenamer.encode(method.getMethodName());
        JMethod jMethod = method.getJMethod();
        MethodVisitor mv = this.cv.visitMethod(jMethod.getAccess(), generatedMethodName, jMethod.getDescriptor(), jMethod.getSignature(), jMethod.getExceptions());
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        Type[] args = Type.getArgumentTypes(jMethod.getDescriptor());
        int methodArg = 1;
        for (Type type : args) {
            int opCode = CommonClassGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, methodArg);
            if (opCode == 22 || opCode == 24) {
                ++methodArg;
            }
            ++methodArg;
        }
        mv.visitMethodInsn(183, ((EasyBeansEjbJarClassMetadata)method.getClassMetadata()).getSuperName(), jMethod.getName(), jMethod.getDescriptor());
        Type returnType = Type.getReturnType(jMethod.getDescriptor());
        CommonClassGenerator.addReturnType(returnType, mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private EasyBeansEjbJarMethodMetadata generateBeanLifeCycleMethod(EasyBeansEjbJarClassMetadata classMetaData, InterceptorType interceptorType) {
        String generatedMethodName = null;
        LinkedList<EasyBeansEjbJarMethodMetadata> existingLifecycleMethods = null;
        switch (interceptorType) {
            case AROUND_INVOKE: 
            case DEP_INJECT: 
            case TIMED_OBJECT: {
                return null;
            }
            case POST_CONSTRUCT: {
                generatedMethodName = "beanPostConstruct$generated";
                existingLifecycleMethods = classMetaData.getPostConstructMethodsMetadata();
                break;
            }
            case PRE_DESTROY: {
                generatedMethodName = "beanPreDestroy$generated";
                existingLifecycleMethods = classMetaData.getPreDestroyMethodsMetadata();
                break;
            }
            case PRE_PASSIVATE: {
                generatedMethodName = "beanPrePassivate$generated";
                existingLifecycleMethods = classMetaData.getPrePassivateMethodsMetadata();
                break;
            }
            case POST_ACTIVATE: {
                generatedMethodName = "beanPostActivate$generated";
                existingLifecycleMethods = classMetaData.getPostActivateMethodsMetadata();
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for interceptorType '" + interceptorType + "'");
            }
        }
        MethodVisitor mv = this.cv.visitMethod(1, generatedMethodName, "()V", null, null);
        CommonClassGenerator.addAnnotationsOnGeneratedMethod(mv);
        mv.visitCode();
        if (existingLifecycleMethods != null) {
            for (EasyBeansEjbJarMethodMetadata method : existingLifecycleMethods) {
                String clName = ((EasyBeansEjbJarClassMetadata)method.getClassMetadata()).getClassName();
                mv.visitVarInsn(25, 0);
                int opcode = 182;
                if (method.isInherited()) {
                    clName = method.getOriginalClassMetadata().getClassName();
                    opcode = 183;
                }
                mv.visitMethodInsn(opcode, clName, method.getMethodName(), method.getJMethod().getDescriptor());
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        JMethod method = new JMethod(1, generatedMethodName, "()V", null, null);
        EasyBeansEjbJarMethodMetadata generatedMetadata = new EasyBeansEjbJarMethodMetadata(method, classMetaData);
        switch (interceptorType) {
            case POST_CONSTRUCT: {
                generatedMetadata.setPostConstruct(true);
                break;
            }
            case PRE_DESTROY: {
                generatedMetadata.setPreDestroy(true);
                break;
            }
            case PRE_PASSIVATE: {
                generatedMetadata.setPrePassivate(true);
                break;
            }
            case POST_ACTIVATE: {
                generatedMetadata.setPostActivate(true);
                break;
            }
            default: {
                throw new RuntimeException("No generated method name found for interceptorType '" + interceptorType + "'");
            }
        }
        classMetaData.addStandardMethodMetadata((IMethodMetadata)generatedMetadata);
        return generatedMetadata;
    }

    private boolean isDependencyInjectionMethod(JMethod jMethod) {
        return "injectedByEasyBeans".equals(jMethod.getName());
    }

    private boolean isInjectedMethod(JMethod jMethod) {
        for (String method : InjectionClassAdapter.INJECTED_METHODS) {
            if (!method.equals(jMethod.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInterceptedMethod(JMethod jMethod) {
        if (this.isDependencyInjectionMethod(jMethod)) {
            return this.classAnnotationMetadata.isBean();
        }
        if (this.isInjectedMethod(jMethod)) {
            return false;
        }
        EasyBeansEjbJarMethodMetadata method = (EasyBeansEjbJarMethodMetadata)this.classAnnotationMetadata.getMethodMetadata(jMethod);
        if (method == null) {
            throw new IllegalStateException("Cannot find a method " + jMethod + " in class " + this.classAnnotationMetadata.getClassName());
        }
        return method.isBusinessMethod();
    }

    private boolean isInterceptorMethod(JMethod jMethod) {
        EasyBeansEjbJarMethodMetadata method = (EasyBeansEjbJarMethodMetadata)this.classAnnotationMetadata.getMethodMetadata(jMethod);
        if (method == null) {
            throw new IllegalStateException("Cannot find a method " + jMethod + " in class " + this.classAnnotationMetadata.getClassName());
        }
        return method.isAroundInvoke() || method.isLifeCycleMethod();
    }

    public List<DefinedClass> getDefinedClasses() {
        return this.definedClasses;
    }
}

