/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StuckThreadDetectionValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.StuckThreadDetectionValve/1.0";
    private static final Log log = LogFactory.getLog(StuckThreadDetectionValve.class);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    private final AtomicInteger stuckCount = new AtomicInteger(0);
    private int threshold = 600;
    private ConcurrentHashMap<Long, MonitoredThread> activeThreads = new ConcurrentHashMap();
    private Queue<CompletedStuckThread> completedStuckThreadsQueue = new ConcurrentLinkedQueue<CompletedStuckThread>();

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public StuckThreadDetectionValve() {
        super(true);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (log.isDebugEnabled()) {
            log.debug("Monitoring stuck threads with threshold = " + this.threshold + " sec");
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    private void notifyStuckThreadDetected(MonitoredThread monitoredThread, long activeTime, int numStuckThreads) {
        if (log.isWarnEnabled()) {
            String msg = sm.getString("stuckThreadDetectionValve.notifyStuckThreadDetected", monitoredThread.getThread().getName(), activeTime, monitoredThread.getStartTime(), numStuckThreads, monitoredThread.getRequestUri(), this.threshold);
            Throwable th = new Throwable();
            th.setStackTrace(monitoredThread.getThread().getStackTrace());
            log.warn(msg, th);
        }
    }

    private void notifyStuckThreadCompleted(String threadName, long activeTime, int numStuckThreads) {
        if (log.isWarnEnabled()) {
            String msg = sm.getString("stuckThreadDetectionValve.notifyStuckThreadCompleted", threadName, activeTime, numStuckThreads);
            log.warn(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.threshold <= 0) {
            this.getNext().invoke(request, response);
            return;
        }
        Long key = new Long(Thread.currentThread().getId());
        StringBuffer requestUrl = request.getRequestURL();
        if (request.getQueryString() != null) {
            requestUrl.append("?");
            requestUrl.append(request.getQueryString());
        }
        MonitoredThread monitoredThread = new MonitoredThread(Thread.currentThread(), requestUrl.toString());
        this.activeThreads.put(key, monitoredThread);
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            this.activeThreads.remove(key);
            if (monitoredThread.markAsDone() == MonitoredThreadState.STUCK) {
                this.completedStuckThreadsQueue.add(new CompletedStuckThread(monitoredThread.getThread().getName(), monitoredThread.getActiveTimeInMillis()));
            }
        }
    }

    @Override
    public void backgroundProcess() {
        super.backgroundProcess();
        long thresholdInMillis = this.threshold * 1000;
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            long activeTime = monitoredThread.getActiveTimeInMillis();
            if (activeTime < thresholdInMillis || !monitoredThread.markAsStuckIfStillRunning()) continue;
            int numStuckThreads = this.stuckCount.incrementAndGet();
            this.notifyStuckThreadDetected(monitoredThread, activeTime, numStuckThreads);
        }
        CompletedStuckThread completedStuckThread = this.completedStuckThreadsQueue.poll();
        while (completedStuckThread != null) {
            int numStuckThreads = this.stuckCount.decrementAndGet();
            this.notifyStuckThreadCompleted(completedStuckThread.getName(), completedStuckThread.getTotalActiveTime(), numStuckThreads);
            completedStuckThread = this.completedStuckThreadsQueue.poll();
        }
    }

    public long[] getStuckThreadIds() {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (MonitoredThread monitoredThread : this.activeThreads.values()) {
            if (!monitoredThread.isMarkedAsStuck()) continue;
            idList.add(monitoredThread.getThread().getId());
        }
        long[] result = new long[idList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)idList.get(i);
        }
        return result;
    }

    private static enum MonitoredThreadState {
        RUNNING,
        STUCK,
        DONE;

    }

    private class CompletedStuckThread {
        private String threadName;
        private long totalActiveTime;

        public CompletedStuckThread(String threadName, long totalActiveTime) {
            this.threadName = threadName;
            this.totalActiveTime = totalActiveTime;
        }

        public String getName() {
            return this.threadName;
        }

        public long getTotalActiveTime() {
            return this.totalActiveTime;
        }
    }

    private class MonitoredThread {
        private final Thread thread;
        private final String requestUri;
        private final long start;
        private final AtomicInteger state = new AtomicInteger(MonitoredThreadState.RUNNING.ordinal());

        public MonitoredThread(Thread thread, String requestUri) {
            this.thread = thread;
            this.requestUri = requestUri;
            this.start = System.currentTimeMillis();
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public long getActiveTimeInMillis() {
            return System.currentTimeMillis() - this.start;
        }

        public Date getStartTime() {
            return new Date(this.start);
        }

        public boolean markAsStuckIfStillRunning() {
            return this.state.compareAndSet(MonitoredThreadState.RUNNING.ordinal(), MonitoredThreadState.STUCK.ordinal());
        }

        public MonitoredThreadState markAsDone() {
            int val = this.state.getAndSet(MonitoredThreadState.DONE.ordinal());
            return MonitoredThreadState.values()[val];
        }

        boolean isMarkedAsStuck() {
            return this.state.get() == MonitoredThreadState.STUCK.ordinal();
        }
    }
}

