/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.myfaces.context.servlet.CookieMap;
import org.apache.myfaces.context.servlet.RequestHeaderMap;
import org.apache.myfaces.context.servlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.servlet.RequestMap;
import org.apache.myfaces.context.servlet.RequestParameterMap;
import org.apache.myfaces.context.servlet.RequestParameterValuesMap;
import org.apache.myfaces.context.servlet.ServletExternalContextImplBase;
import org.apache.myfaces.context.servlet.SessionMap;
import org.apache.myfaces.shared_impl.context.flash.FlashImpl;
import org.apache.myfaces.util.EnumerationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletExternalContextImpl
extends ServletExternalContextImplBase {
    private static final Logger log = Logger.getLogger(ServletExternalContextImpl.class.getName());
    private static final String URL_PARAM_SEPERATOR = "&";
    private static final String URL_QUERY_SEPERATOR = "?";
    private static final String URL_FRAGMENT_SEPERATOR = "#";
    private static final String URL_NAME_VALUE_PAIR_SEPERATOR = "=";
    private ServletRequest _servletRequest;
    private ServletResponse _servletResponse;
    private Map<String, Object> _sessionMap;
    private Map<String, Object> _requestMap;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private Map<String, String> _requestHeaderMap;
    private Map<String, String[]> _requestHeaderValuesMap;
    private Map<String, Object> _requestCookieMap;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private String _requestServletPath;
    private String _requestPathInfo;

    public ServletExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        super(servletContext);
        this._servletRequest = servletRequest;
        this._servletResponse = servletResponse;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._httpServletRequest = this.isHttpServletRequest(servletRequest) ? (HttpServletRequest)servletRequest : null;
        HttpServletResponse httpServletResponse = this._httpServletResponse = this.isHttpServletResponse(servletResponse) ? (HttpServletResponse)servletResponse : null;
        if (this._httpServletRequest != null) {
            this._requestServletPath = this._httpServletRequest.getServletPath();
            this._requestPathInfo = this._httpServletRequest.getPathInfo();
        }
    }

    @Override
    public void release() {
        super.release();
        this._servletRequest = null;
        this._servletResponse = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._httpServletRequest = null;
        this._httpServletResponse = null;
    }

    public Object getSession(boolean create) {
        this.checkHttpServletRequest();
        return ((HttpServletRequest)this._servletRequest).getSession(create);
    }

    public Object getRequest() {
        return this._servletRequest;
    }

    public int getRequestContentLength() {
        return this._servletRequest.getContentLength();
    }

    public Object getResponse() {
        return this._servletResponse;
    }

    public int getResponseBufferSize() {
        return this._servletResponse.getBufferSize();
    }

    public String getResponseContentType() {
        return this._servletResponse.getContentType();
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this._servletResponse.getOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this._servletResponse.getWriter();
    }

    public Map<String, Object> getSessionMap() {
        if (this._sessionMap == null) {
            this.checkHttpServletRequest();
            this._sessionMap = new SessionMap(this._httpServletRequest);
        }
        return this._sessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._servletRequest);
        }
        return this._requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._servletRequest);
        }
        return this._requestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._servletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public int getRequestServerPort() {
        return this._servletRequest.getServerPort();
    }

    public Iterator<String> getRequestParameterNames() {
        return new EnumerationIterator<String>(this._servletRequest.getParameterNames());
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderMap = new RequestHeaderMap(this._httpServletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderValuesMap = new RequestHeaderValuesMap(this._httpServletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this._requestCookieMap == null) {
            this.checkHttpServletRequest();
            this._requestCookieMap = new CookieMap(this._httpServletRequest);
        }
        return this._requestCookieMap;
    }

    public Locale getRequestLocale() {
        return this._servletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        this.checkHttpServletRequest();
        return this._requestPathInfo;
    }

    public String getRequestContentType() {
        return this._servletRequest.getContentType();
    }

    public String getRequestContextPath() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getContextPath();
    }

    public String getRequestScheme() {
        return this._servletRequest.getScheme();
    }

    public String encodeActionURL(String url) {
        this.checkNull(url, "url");
        this.checkHttpServletRequest();
        return ((HttpServletResponse)this._servletResponse).encodeURL(url);
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        return this.encodeURL(baseUrl, parameters);
    }

    public String encodeResourceURL(String url) {
        this.checkNull(url, "url");
        this.checkHttpServletRequest();
        return ((HttpServletResponse)this._servletResponse).encodeURL(url);
    }

    public String encodeNamespace(String s) {
        return s;
    }

    public String encodePartialActionURL(String url) {
        this.checkNull(url, "url");
        this.checkHttpServletRequest();
        return ((HttpServletResponse)this._servletResponse).encodeURL(url);
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        return this._httpServletResponse.encodeRedirectURL(this.encodeURL(baseUrl, parameters));
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this._servletRequest.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this._servletResponse).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this._servletRequest, this._servletResponse);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String getRequestServerName() {
        return this._servletRequest.getServerName();
    }

    public String getRequestServletPath() {
        this.checkHttpServletRequest();
        return this._requestServletPath;
    }

    public String getAuthType() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getAuthType();
    }

    public String getRemoteUser() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        this.checkNull(role, "role");
        this.checkHttpServletRequest();
        return this._httpServletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getUserPrincipal();
    }

    public void invalidateSession() {
        HttpSession session = (HttpSession)this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isResponseCommitted() {
        return this._httpServletResponse.isCommitted();
    }

    public void redirect(String url) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext.isPartialRequest()) {
            PartialResponseWriter writer = partialViewContext.getPartialResponseWriter();
            this.setResponseContentType("text/xml");
            this.setResponseCharacterEncoding("UTF-8");
            this.addResponseHeader("Cache-control", "no-cache");
            writer.startDocument();
            writer.redirect(url);
            writer.endDocument();
            facesContext.responseComplete();
        } else if (this._servletResponse instanceof HttpServletResponse) {
            ((HttpServletResponse)this._servletResponse).sendRedirect(url);
            facesContext.responseComplete();
        } else {
            throw new IllegalArgumentException("Only HttpServletResponse supported");
        }
    }

    public void responseFlushBuffer() throws IOException {
        this.checkHttpServletResponse();
        this._httpServletResponse.flushBuffer();
    }

    public void responseReset() {
        this.checkHttpServletResponse();
        this._httpServletResponse.reset();
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        this.checkHttpServletResponse();
        if (message == null) {
            this._httpServletResponse.sendError(statusCode);
        } else {
            this._httpServletResponse.sendError(statusCode, message);
        }
    }

    public Iterator<Locale> getRequestLocales() {
        this.checkHttpServletRequest();
        return new EnumerationIterator<Locale>(this._httpServletRequest.getLocales());
    }

    public void setRequest(Object request) {
        this._servletRequest = (ServletRequest)request;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestCookieMap = null;
        this._sessionMap = null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._servletRequest.setCharacterEncoding(encoding);
    }

    public String getRequestCharacterEncoding() {
        return this._servletRequest.getCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return this._servletResponse.getCharacterEncoding();
    }

    public void setResponse(Object response) {
        this._servletResponse = (ServletResponse)response;
    }

    public void setResponseBufferSize(int size) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setBufferSize(size);
    }

    public void setResponseCharacterEncoding(String encoding) {
        this._servletResponse.setCharacterEncoding(encoding);
    }

    public void setResponseContentLength(int length) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setContentLength(length);
    }

    public void setResponseContentType(String contentType) {
        if (!this._servletResponse.isCommitted()) {
            this._servletResponse.setContentType(contentType);
        } else {
            log.severe("Cannot set content type. Response already committed");
        }
    }

    public void setResponseHeader(String name, String value) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setHeader(name, value);
    }

    public void setResponseStatus(int statusCode) {
        this.checkHttpServletResponse();
        this._httpServletResponse.setStatus(statusCode);
    }

    private void checkHttpServletRequest() {
        if (this._httpServletRequest == null) {
            throw new UnsupportedOperationException("Only HttpServletRequest supported");
        }
    }

    private boolean isHttpServletRequest(ServletRequest servletRequest) {
        return servletRequest instanceof HttpServletRequest;
    }

    private void checkHttpServletResponse() {
        if (this._httpServletRequest == null) {
            throw new UnsupportedOperationException("Only HttpServletResponse supported");
        }
    }

    private boolean isHttpServletResponse(ServletResponse servletResponse) {
        return servletResponse instanceof HttpServletResponse;
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        this.checkHttpServletResponse();
        Cookie cookie = new Cookie(name, value);
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String propertyKey = entry.getKey();
                Object propertyValue = entry.getValue();
                if ("comment".equals(propertyKey)) {
                    cookie.setComment((String)propertyValue);
                    continue;
                }
                if ("domain".equals(propertyKey)) {
                    cookie.setDomain((String)propertyValue);
                    continue;
                }
                if ("maxAge".equals(propertyKey)) {
                    cookie.setMaxAge(((Integer)propertyValue).intValue());
                    continue;
                }
                if ("secure".equals(propertyKey)) {
                    cookie.setSecure(((Boolean)propertyValue).booleanValue());
                    continue;
                }
                if ("path".equals(propertyKey)) {
                    cookie.setPath((String)propertyValue);
                    continue;
                }
                throw new IllegalArgumentException("Unused key when creating Cookie");
            }
        }
        this._httpServletResponse.addCookie(cookie);
    }

    public void addResponseHeader(String name, String value) {
        this._httpServletResponse.addHeader(name, value);
    }

    private String encodeURL(String baseUrl, Map<String, List<String>> parameters) {
        this.checkNull(baseUrl, "url");
        this.checkHttpServletRequest();
        String fragment = null;
        String queryString = null;
        HashMap<String, List<Object>> paramMap = new HashMap<String, List<Object>>();
        int index = baseUrl.indexOf(URL_FRAGMENT_SEPERATOR);
        if (index != -1) {
            fragment = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
        }
        if ((index = baseUrl.indexOf(URL_QUERY_SEPERATOR)) != -1) {
            queryString = baseUrl.substring(index + 1);
            baseUrl = baseUrl.substring(0, index);
            String[] nameValuePairs = queryString.split(URL_PARAM_SEPERATOR);
            for (int i = 0; i < nameValuePairs.length; ++i) {
                String[] currentPair = nameValuePairs[i].split(URL_NAME_VALUE_PAIR_SEPERATOR);
                ArrayList<String> value = new ArrayList<String>(1);
                value.add(currentPair.length > 1 ? currentPair[1] : "");
                paramMap.put(currentPair[0], value);
            }
        }
        if (parameters != null && parameters.size() > 0) {
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                if (pair.getKey() == null || pair.getKey().trim().length() == 0) continue;
                paramMap.put(pair.getKey(), this._evaluateValueExpressions(pair.getValue()));
            }
        }
        StringBuilder newUrl = new StringBuilder(baseUrl);
        if (paramMap.size() > 0) {
            boolean isFirstPair = true;
            for (Map.Entry pair : paramMap.entrySet()) {
                for (String value : (List)pair.getValue()) {
                    if (!isFirstPair) {
                        newUrl.append(URL_PARAM_SEPERATOR);
                    } else {
                        newUrl.append(URL_QUERY_SEPERATOR);
                        isFirstPair = false;
                    }
                    newUrl.append((String)pair.getKey());
                    newUrl.append(URL_NAME_VALUE_PAIR_SEPERATOR);
                    try {
                        newUrl.append(URLEncoder.encode(value, this.getResponseCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new UnsupportedOperationException("Encoding type=" + this.getResponseCharacterEncoding() + " not supported", e);
                    }
                }
            }
        }
        if (fragment != null) {
            newUrl.append(URL_FRAGMENT_SEPERATOR + fragment);
        }
        return newUrl.toString();
    }

    private List<String> _evaluateValueExpressions(List<String> values) {
        ArrayList<String> target = new ArrayList<String>(values.size());
        FacesContext context = FacesContext.getCurrentInstance();
        for (String value : values) {
            if (this._isExpression(value)) {
                value = (String)context.getApplication().evaluateExpressionGet(context, value, String.class);
            }
            target.add(value);
        }
        return target;
    }

    private boolean _isExpression(String text) {
        return text.indexOf("#{") != -1;
    }

    public Flash getFlash() {
        return FlashImpl.getCurrentInstance(this);
    }
}

