/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.view.facelets.tag.BeanPropertyTagRule;
import org.apache.myfaces.view.facelets.tag.MetadataImpl;
import org.apache.myfaces.view.facelets.tag.MetadataTargetImpl;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaRulesetImpl
extends MetaRuleset {
    private static final Metadata NONE = new NullMetadata();
    private static final Logger log = Logger.getLogger(MetaRulesetImpl.class.getName());
    private static final WeakHashMap<ClassLoader, Map<String, MetadataTarget>> _metadata = new WeakHashMap();
    private final Map<String, TagAttribute> _attributes;
    private final List<Metadata> _mappers;
    private final List<MetaRule> _rules;
    private final Tag _tag;
    private final Class<?> _type;

    public static void clearMetadataTargetCache() {
        _metadata.remove(ClassUtils.getContextClassLoader());
    }

    private static Map<String, MetadataTarget> getMetaData() {
        Map<String, MetadataTarget> metadata = _metadata.get(ClassUtils.getContextClassLoader());
        if (metadata == null) {
            metadata = new HashMap<String, MetadataTarget>();
            _metadata.put(ClassUtils.getContextClassLoader(), metadata);
        }
        return metadata;
    }

    public MetaRulesetImpl(Tag tag, Class<?> type) {
        this._tag = tag;
        this._type = type;
        this._attributes = new HashMap<String, TagAttribute>();
        this._mappers = new ArrayList<Metadata>();
        this._rules = new ArrayList<MetaRule>();
        for (TagAttribute attribute : this._tag.getAttributes().getAll()) {
            this._attributes.put(attribute.getLocalName(), attribute);
        }
        this._rules.add(BeanPropertyTagRule.Instance);
    }

    public MetaRuleset add(Metadata mapper) {
        ParameterCheck.notNull("mapper", mapper);
        if (!this._mappers.contains(mapper)) {
            this._mappers.add(mapper);
        }
        return this;
    }

    public MetaRuleset addRule(MetaRule rule) {
        ParameterCheck.notNull("rule", rule);
        this._rules.add(rule);
        return this;
    }

    public MetaRuleset alias(String attribute, String property) {
        ParameterCheck.notNull("attribute", attribute);
        ParameterCheck.notNull("property", property);
        TagAttribute attr = this._attributes.remove(attribute);
        if (attr != null) {
            this._attributes.put(property, attr);
        }
        return this;
    }

    public Metadata finish() {
        assert (!this._rules.isEmpty());
        if (!this._attributes.isEmpty()) {
            MetadataTarget target = this._getMetadataTarget();
            int ruleEnd = this._rules.size() - 1;
            for (Map.Entry<String, TagAttribute> entry : this._attributes.entrySet()) {
                MetaRule rule;
                Metadata data = null;
                int i = ruleEnd;
                while ((data = (rule = this._rules.get(i)).applyRule(entry.getKey(), entry.getValue(), target)) == null && --i >= 0) {
                }
                if (data == null) {
                    if (!log.isLoggable(Level.SEVERE)) continue;
                    log.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this._type.getName());
                    continue;
                }
                this._mappers.add(data);
            }
        }
        if (this._mappers.isEmpty()) {
            return NONE;
        }
        return new MetadataImpl(this._mappers.toArray(new Metadata[this._mappers.size()]));
    }

    public MetaRuleset ignore(String attribute) {
        ParameterCheck.notNull("attribute", attribute);
        this._attributes.remove(attribute);
        return this;
    }

    public MetaRuleset ignoreAll() {
        this._attributes.clear();
        return this;
    }

    private final MetadataTarget _getMetadataTarget() {
        String metaKey;
        Map<String, MetadataTarget> metadata = MetaRulesetImpl.getMetaData();
        MetadataTarget meta = metadata.get(metaKey = this._type.getName());
        if (meta == null) {
            try {
                meta = new MetadataTargetImpl(this._type);
            }
            catch (IntrospectionException e) {
                throw new TagException(this._tag, "Error Creating TargetMetadata", (Throwable)e);
            }
            metadata.put(metaKey, meta);
        }
        return meta;
    }

    private static class NullMetadata
    extends Metadata {
        private NullMetadata() {
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
        }
    }
}

