/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.thread;

import java.util.concurrent.Executor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.IWaitControl;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.TimeoutPoolException;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.ExpireWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.InfiniteWaitControl;
import org.ow2.util.pool.impl.enhanced.impl.waitcontrol.NoWaitControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool
implements Executor {
    private static final Log LOG = LogFactory.getLog(ThreadPool.class);
    private IPool<IReusableThread> pool;
    private Long waitTimeBeforeUsingSelfThread;

    public ThreadPool(IPool<IReusableThread> pool) {
        this(pool, null);
    }

    public ThreadPool(IPool<IReusableThread> pool, Long waitTimeBeforeUsingSelfThread) {
        this.pool = pool;
        this.waitTimeBeforeUsingSelfThread = waitTimeBeforeUsingSelfThread;
    }

    @Override
    public void execute(Runnable runnable) {
        long longValue;
        boolean getCalled = false;
        IWaitControl waitControl = this.waitTimeBeforeUsingSelfThread == null ? new InfiniteWaitControl() : ((longValue = this.waitTimeBeforeUsingSelfThread.longValue()) <= 0L ? NoWaitControl.INSTANCE : new ExpireWaitControl(System.currentTimeMillis() + longValue));
        while (!getCalled) {
            try {
                this.pool.get(waitControl).setUsed(this.pool, runnable);
                getCalled = true;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted", new Object[]{e});
            }
            catch (TimeoutPoolException e) {
                if (!waitControl.canContinueToWait()) {
                    runnable.run();
                    getCalled = true;
                    continue;
                }
                LOG.warn((Object)"Unexpected exception", new Object[]{e});
            }
            catch (PoolException e) {
                LOG.warn((Object)"PoolException", new Object[]{e});
            }
        }
    }
}

