/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.util;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Date;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DMQManager {
    private ClientMessages deadMessages = null;
    private AgentId destDmqId = null;
    private AgentId senderId = null;
    public static Logger logger = Debug.getLogger((String)DMQManager.class.getName());

    public DMQManager(AgentId specificDmq, AgentId currentDestDmq, AgentId senderId) {
        this.destDmqId = specificDmq != null ? specificDmq : (currentDestDmq != null ? currentDestDmq : Queue.getDefaultDMQId());
        this.senderId = senderId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.getClass().getName() + " created, destDmqId: " + this.destDmqId));
        }
    }

    public DMQManager(AgentId currentDestDmq, AgentId senderId) {
        this(null, currentDestDmq, senderId);
    }

    public void addDeadMessage(Message mess, short reason) {
        if (this.destDmqId != null) {
            String ERROR_COUNT = "JMS_JORAM_ERRORCOUNT";
            Integer errorCount = (Integer)mess.getProperty(ERROR_COUNT);
            errorCount = errorCount == null ? new Integer(1) : new Integer(errorCount + 1);
            String causePropertyName = "JMS_JORAM_ERRORCAUSE_" + errorCount;
            String codePropertyName = "JMS_JORAM_ERRORCODE_" + errorCount;
            mess.setProperty(ERROR_COUNT, (Object)errorCount);
            switch (reason) {
                case 0: {
                    mess.setProperty(causePropertyName, (Object)("Expired at " + new Date(mess.expiration)));
                    mess.setProperty(codePropertyName, (Object)new Short(0));
                    break;
                }
                case 1: {
                    mess.setProperty(causePropertyName, (Object)"Destination is not writable");
                    mess.setProperty(codePropertyName, (Object)new Short(1));
                    break;
                }
                case 2: {
                    mess.setProperty(causePropertyName, (Object)("Undeliverable after " + mess.deliveryCount + " tries"));
                    mess.setProperty(codePropertyName, (Object)new Short(2));
                    break;
                }
                case 3: {
                    mess.setProperty(causePropertyName, (Object)"Message deleted by an admin");
                    mess.setProperty(codePropertyName, (Object)new Short(3));
                    break;
                }
                case 4: {
                    mess.setProperty(causePropertyName, (Object)"Deleted destination");
                    mess.setProperty(codePropertyName, (Object)new Short(4));
                    break;
                }
                case 5: {
                    mess.setProperty(causePropertyName, (Object)"Queue full");
                    mess.setProperty(codePropertyName, (Object)new Short(5));
                    break;
                }
                case 6: {
                    mess.setProperty(causePropertyName, (Object)"Unexpected error");
                    mess.setProperty(codePropertyName, (Object)new Short(6));
                    break;
                }
                case 7: {
                    mess.setProperty(causePropertyName, (Object)"Interceptors");
                    mess.setProperty(codePropertyName, (Object)new Short(7));
                    break;
                }
            }
            if (this.deadMessages == null) {
                this.deadMessages = new ClientMessages();
            }
            mess.expiration = 0L;
            this.deadMessages.addMessage(mess);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this.getClass().getName() + ", addDeadMessage for dmq: " + this.destDmqId + ". Msg: " + mess));
        }
    }

    public void sendToDMQ() {
        if (this.deadMessages != null) {
            this.deadMessages.setExpiration(0L);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this.getClass().getName() + ", sendToDMQ " + this.destDmqId));
            }
            if (this.destDmqId != null && !this.destDmqId.equals((Object)this.senderId)) {
                Channel.sendTo((AgentId)this.destDmqId, (Notification)this.deadMessages);
            } else if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)(this.getClass().getName() + ", can't send to itself, messages dropped"));
            }
        }
    }
}

