/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.impl;

import fr.dyade.aaa.jndi2.impl.NamingContext;
import fr.dyade.aaa.jndi2.impl.NamingContextId;
import fr.dyade.aaa.jndi2.impl.Trace;
import fr.dyade.aaa.util.Transaction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;

public class StorageManager {
    public static final String ROOT = "jndiStorage";
    public static final String CTX_COUNTER = "jndiCtxCounter";
    public static final String CTX_INDEX = "jndiCtxIndex";
    private long contextCounter;
    private Transaction transaction;
    private Hashtable nameToIdIndex;
    private Object serverId;

    public StorageManager(Transaction transaction, Object serverId) {
        this.transaction = transaction;
        this.serverId = serverId;
    }

    public void initialize() throws Exception {
        Long contextCounterL = (Long)this.transaction.load(CTX_COUNTER);
        this.contextCounter = contextCounterL == null ? 0L : contextCounterL;
        this.nameToIdIndex = (Hashtable)this.transaction.load(CTX_INDEX);
        if (this.nameToIdIndex == null) {
            this.nameToIdIndex = new Hashtable();
        }
    }

    public NamingContext newNamingContext(Object ownerId, NamingContextId ncid, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.newNamingContext(" + ownerId + ',' + name + ')'));
        }
        if (ncid == null) {
            ncid = this.newNamingContextId();
        }
        NamingContext nc = new NamingContext(ncid, ownerId, name);
        this.addNamingContext(nc, name);
        return nc;
    }

    public void addNamingContext(NamingContext nc, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.addNamingContext(" + nc + ',' + name + ')'));
        }
        this.nameToIdIndex.put(name, nc.getId());
        this.storeIndex();
        this.storeNamingContext(nc);
    }

    private NamingContextId newNamingContextId() throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"StorageManager.newNamingContextId()");
        }
        NamingContextId ncid = new NamingContextId(this.serverId, this.contextCounter);
        ++this.contextCounter;
        try {
            this.transaction.save((Serializable)new Long(this.contextCounter), CTX_COUNTER);
            return ncid;
        }
        catch (IOException ioexc) {
            NamingException nexc = new NamingException();
            nexc.setRootCause(ioexc);
            throw nexc;
        }
    }

    public void storeNamingContext(NamingContext nc) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.storeNamingContext(" + nc + ')'));
        }
        try {
            this.transaction.save((Serializable)nc, ROOT, nc.getId().toString());
        }
        catch (IOException exc) {
            NamingException ne = new NamingException(exc.getMessage());
            ne.setRootCause(exc);
            throw ne;
        }
    }

    public NamingContext loadNamingContext(NamingContextId ncid) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.loadNamingContext(" + ncid + ')'));
        }
        return this.loadNamingContext(ncid.toString());
    }

    public NamingContext loadNamingContext(String fileName) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.loadNamingContext(" + fileName + ')'));
        }
        try {
            Object obj = this.transaction.load(ROOT, fileName);
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)(" -> obj = " + obj));
            }
            return (NamingContext)obj;
        }
        catch (IOException exc) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            NamingException ne = new NamingException(exc.getMessage());
            ne.setRootCause(exc);
            throw ne;
        }
        catch (ClassNotFoundException exc2) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc2);
            }
            NamingException ne = new NamingException(exc2.getMessage());
            ne.setRootCause(exc2);
            throw ne;
        }
    }

    public void delete(NamingContextId ncid, CompositeName name) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("StorageManager.delete(" + ncid + ',' + name + ')'));
        }
        this.transaction.delete(ROOT, ncid.toString());
        this.nameToIdIndex.remove(name);
        this.storeIndex();
    }

    private void storeIndex() throws NamingException {
        try {
            this.transaction.save((Serializable)this.nameToIdIndex, CTX_INDEX);
        }
        catch (IOException exc) {
            NamingException ne = new NamingException(exc.getMessage());
            ne.setRootCause(exc);
            throw ne;
        }
    }

    public Enumeration getContextIds() {
        return this.nameToIdIndex.elements();
    }

    public Enumeration getContextNames() {
        return this.nameToIdIndex.keys();
    }

    public NamingContextId getIdFromName(CompositeName name) {
        return (NamingContextId)this.nameToIdIndex.get(name);
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        out.writeLong(this.contextCounter);
        out.writeObject(this.nameToIdIndex);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.contextCounter = in.readLong();
        this.nameToIdIndex = (Hashtable)in.readObject();
    }
}

