/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.server;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.jndi2.impl.MissingContextException;
import fr.dyade.aaa.jndi2.impl.MissingRecordException;
import fr.dyade.aaa.jndi2.impl.NotOwnerException;
import fr.dyade.aaa.jndi2.impl.ObjectRecord;
import fr.dyade.aaa.jndi2.impl.Record;
import fr.dyade.aaa.jndi2.impl.ServerImpl;
import fr.dyade.aaa.jndi2.msg.BindRequest;
import fr.dyade.aaa.jndi2.msg.ChangeOwnerRequest;
import fr.dyade.aaa.jndi2.msg.CreateSubcontextRequest;
import fr.dyade.aaa.jndi2.msg.DestroySubcontextRequest;
import fr.dyade.aaa.jndi2.msg.JndiAdminRequest;
import fr.dyade.aaa.jndi2.msg.JndiError;
import fr.dyade.aaa.jndi2.msg.JndiReadRequest;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.msg.ListBindingsReply;
import fr.dyade.aaa.jndi2.msg.ListBindingsRequest;
import fr.dyade.aaa.jndi2.msg.ListReply;
import fr.dyade.aaa.jndi2.msg.ListRequest;
import fr.dyade.aaa.jndi2.msg.LookupReply;
import fr.dyade.aaa.jndi2.msg.LookupRequest;
import fr.dyade.aaa.jndi2.msg.UnbindRequest;
import fr.dyade.aaa.jndi2.server.Container;
import fr.dyade.aaa.jndi2.server.LifeCycleListener;
import fr.dyade.aaa.jndi2.server.RequestContext;
import fr.dyade.aaa.jndi2.server.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;

public class RequestManager
implements LifeCycleListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private Container container;
    private transient ServerImpl impl;

    public void setContainer(Container container) {
        this.container = container;
    }

    public final AgentId getId() {
        return this.container.getId();
    }

    public void sendTo(AgentId to, Notification not) {
        this.container.sendNotification(to, not);
    }

    public void agentInitialize(boolean firstTime) throws Exception {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("\n\nRequestManager.agentInitialize(" + firstTime + ')'));
        }
        this.impl = new ServerImpl(AgentServer.getTransaction(), this.getId(), this.getRootOwnerId());
        this.impl.initialize();
    }

    public void agentFinalize(boolean lastTime) {
    }

    protected AgentId getRootOwnerId() {
        return this.getId();
    }

    protected final ServerImpl getServerImpl() {
        return this.impl;
    }

    public JndiReply invoke(RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.invoke(" + reqCtx + ')'));
        }
        JndiRequest request = reqCtx.getRequest();
        try {
            if (request instanceof JndiReadRequest) {
                return this.invokeReadRequest(reqCtx);
            }
            if (request instanceof JndiAdminRequest) {
                return this.invokeAdminRequest(reqCtx);
            }
            return this.invokeWriteRequest(reqCtx);
        }
        catch (MissingContextException mce) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)mce);
            }
            return this.onMissingContext(mce, reqCtx);
        }
        catch (MissingRecordException nnfe) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)nnfe);
            }
            return this.onMissingRecord(nnfe, reqCtx);
        }
        catch (NamingException nexc) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)nexc);
            }
            return new JndiError(nexc);
        }
    }

    protected JndiReply invokeReadRequest(RequestContext reqCtx) throws NamingException {
        JndiRequest request;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.invokeReadRequest(" + reqCtx + ')'));
        }
        if ((request = reqCtx.getRequest()) instanceof LookupRequest) {
            Record obj = this.lookup((LookupRequest)request);
            if (obj != null) {
                ObjectRecord or = (ObjectRecord)obj;
                return new LookupReply(or.getObject());
            }
            return new JndiReply();
        }
        if (request instanceof ListBindingsRequest) {
            Binding[] obj = this.listBindings((ListBindingsRequest)request);
            return new ListBindingsReply(obj);
        }
        if (request instanceof ListRequest) {
            NameClassPair[] obj = this.list((ListRequest)request);
            return new ListReply(obj);
        }
        return new JndiError(new NamingException("Unknown operation"));
    }

    protected JndiReply invokeWriteRequest(RequestContext reqCtx) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.invokeWriteRequest(" + reqCtx + ',' + ')'));
        }
        try {
            JndiRequest request = reqCtx.getRequest();
            if (request instanceof BindRequest) {
                this.bind((BindRequest)request);
                return new JndiReply();
            }
            if (request instanceof UnbindRequest) {
                this.unbind((UnbindRequest)request);
                return new JndiReply();
            }
            if (request instanceof CreateSubcontextRequest) {
                this.createSubcontext((CreateSubcontextRequest)request);
                return new JndiReply();
            }
            if (request instanceof DestroySubcontextRequest) {
                this.destroySubcontext((DestroySubcontextRequest)request);
                return new JndiReply();
            }
            return new JndiError(new NamingException("Unknown operation"));
        }
        catch (NotOwnerException noexc) {
            if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
                Trace.logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)noexc);
            }
            return this.invokeOwner((AgentId)noexc.getOwner(), reqCtx);
        }
    }

    protected JndiReply invokeAdminRequest(RequestContext reqCtx) throws NamingException {
        JndiRequest request = reqCtx.getRequest();
        if (request instanceof ChangeOwnerRequest) {
            this.changeOwner((ChangeOwnerRequest)request);
            return new JndiReply();
        }
        return new JndiError(new NamingException("Unknown admin operation"));
    }

    private void bind(BindRequest request) throws NamingException {
        if (request.isRebind()) {
            this.impl.rebind(request.getName(), request.getObject());
        } else {
            this.impl.bind(request.getName(), request.getObject());
        }
    }

    private void unbind(UnbindRequest request) throws NamingException {
        this.impl.unbind(request.getName());
    }

    private Record lookup(LookupRequest request) throws NamingException {
        return this.impl.lookup(request.getName());
    }

    private NameClassPair[] list(ListRequest request) throws NamingException {
        return this.impl.list(request.getName());
    }

    private Binding[] listBindings(ListBindingsRequest request) throws NamingException {
        return this.impl.listBindings(request.getName());
    }

    protected void createSubcontext(CreateSubcontextRequest request) throws NamingException {
        this.impl.createSubcontext(request.getName());
    }

    private void destroySubcontext(DestroySubcontextRequest request) throws NamingException {
        this.impl.destroySubcontext(request.getName());
    }

    protected void changeOwner(ChangeOwnerRequest request) throws NamingException {
        AgentId newOwnerId;
        try {
            newOwnerId = AgentId.fromString((String)request.getOwnerId());
        }
        catch (Exception exc) {
            NamingException ne = new NamingException(exc.toString());
            ne.setRootCause(exc);
            throw ne;
        }
        if (this.getId().equals((Object)newOwnerId)) {
            throw new NamingException("Server already owner");
        }
        this.impl.changeOwner(request.getName(), newOwnerId);
    }

    protected JndiReply invokeOwner(AgentId owner, RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.invokeOwner(" + owner + ',' + reqCtx + ')'));
        }
        return new JndiError(new NamingException("Not owner"));
    }

    protected JndiReply onMissingContext(MissingContextException mce, RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.onMissingContext(" + mce + ',' + reqCtx + ')'));
        }
        throw new Error(mce.toString());
    }

    protected JndiReply onMissingRecord(MissingRecordException mre, RequestContext reqCtx) {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("RequestManager.onMissingRecord(" + mre + ',' + reqCtx + ')'));
        }
        return new JndiError((NamingException)mre.getNameNotFoundException());
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        this.impl.writeBag(out);
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.impl = new ServerImpl(AgentServer.getTransaction(), this.getId(), this.getRootOwnerId());
        this.impl.readBag(in);
    }
}

