/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dsi;

import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.slf4j.Logger;
import org.jacorb.util.Time;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    private final RequestInputStream inputStream;
    private ReplyOutputStream out;
    private final GIOPConnection connection;
    private UtcT requestStartTime = null;
    private UtcT requestEndTime = null;
    private UtcT replyEndTime = null;
    private List scopes;
    private final boolean cachePoaNames;
    private int replyStatus = 0;
    private final byte[] oid;
    private final byte[] object_key;
    private Object reference = null;
    private String[] rest_of_name = null;
    private boolean isStreamBased;
    private SystemException sys_ex;
    private org.omg.PortableServer.ForwardRequest location_forward;
    private Any exception;
    private Any result;
    private NVList argList;
    private final ORB orb;
    private boolean usePreconstructedReply = false;
    private ServerRequestInfoImpl info = null;
    private final Logger logger;

    public ServerRequest(ORB oRB, RequestInputStream requestInputStream, GIOPConnection gIOPConnection) {
        this.orb = oRB;
        Configuration configuration = oRB.getConfiguration();
        this.logger = configuration.getLogger("jacorb.org.giop");
        this.cachePoaNames = configuration.getAttribute("jacorb.cachePoaNames", "off").equals("on");
        this.inputStream = requestInputStream;
        this.connection = gIOPConnection;
        this.calcTimingPolicies();
        this.object_key = oRB.mapObjectKey(ParsedIOR.extractObjectKey(requestInputStream.req_hdr.target, oRB));
        this.oid = POAUtil.extractOID(this.object_key);
    }

    public void setRemainingPOAName(String[] stringArray) {
        this.rest_of_name = stringArray;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    public String operation() {
        return this.inputStream.req_hdr.operation;
    }

    public Any result() {
        if (this.isStreamBased) {
            Any any = this.orb.create_any();
            CDROutputStream cDROutputStream = (CDROutputStream)any.create_output_stream();
            byte[] byArray = this.out.getBody();
            cDROutputStream.setBuffer(byArray);
            cDROutputStream.skip(byArray.length);
            return any;
        }
        return this.result;
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.argList;
    }

    public Any except() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.exception;
    }

    public ReplyStatusType_1_2 status() {
        return ReplyStatusType_1_2.from_int(this.replyStatus);
    }

    public Context ctx() {
        return null;
    }

    public void arguments(org.omg.CORBA.NVList nVList) {
        this.argList = (NVList)nVList;
        if (this.argList != null) {
            this.inputStream.mark(0);
            Parameter[] parameterArray = this.argList.iterator();
            while (parameterArray.hasNext()) {
                org.omg.CORBA.NamedValue namedValue = (org.omg.CORBA.NamedValue)parameterArray.next();
                if (namedValue.flags() == 2) continue;
                try {
                    namedValue.value().read_value(this.inputStream, namedValue.value().type());
                }
                catch (Exception exception) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + namedValue.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.inputStream.reset();
            }
            catch (Exception exception) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                parameterArray = new Parameter[this.argList.count()];
                for (int i = 0; i < parameterArray.length; ++i) {
                    try {
                        org.omg.CORBA.NamedValue namedValue = this.argList.item(i);
                        ParameterMode parameterMode = null;
                        if (namedValue.flags() == 1) {
                            parameterMode = ParameterMode.PARAM_IN;
                        } else if (namedValue.flags() == 2) {
                            parameterMode = ParameterMode.PARAM_OUT;
                        } else if (namedValue.flags() == 3) {
                            parameterMode = ParameterMode.PARAM_INOUT;
                        }
                        parameterArray[i] = new Parameter(namedValue.value(), parameterMode);
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.info("Caught exception ", exception);
                    }
                }
                this.info.setArguments(parameterArray);
                ServerInterceptorIterator serverInterceptorIterator = this.orb.getInterceptorManager().getServerIterator();
                try {
                    serverInterceptorIterator.iterate(this.info, (short)1);
                }
                catch (ForwardRequest forwardRequest) {
                    this.setLocationForward(new org.omg.PortableServer.ForwardRequest(forwardRequest.forward));
                }
                catch (UserException userException) {
                    this.logger.error("uncaught userexception", userException);
                }
                catch (SystemException systemException) {
                    this.setSystemException(systemException);
                }
                this.info = null;
            }
        }
    }

    public void set_result(Any any) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.result = any;
    }

    public void set_exception(Any any) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.exception = any;
        this.replyStatus = 1;
    }

    public void reply() {
        if (this.responseExpected()) {
            if (this.usePreconstructedReply) {
                try {
                    this.connection.sendReply(this.out);
                }
                catch (Exception exception) {
                    this.logger.info("Error replying to request!", exception);
                }
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ServerRequest: reply to " + this.operation());
            }
            try {
                if (this.out == null) {
                    this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.from_int(this.replyStatus), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
                }
                if (!this.isStreamBased) {
                    if (this.replyStatus == 1) {
                        this.exception.write_value(this.out);
                    } else if (this.replyStatus == 0) {
                        if (this.result != null) {
                            this.result.write_value(this.out);
                        }
                        if (this.argList != null) {
                            Iterator iterator = this.argList.iterator();
                            while (iterator.hasNext()) {
                                NamedValue namedValue = (NamedValue)iterator.next();
                                if (namedValue.flags() == 1) continue;
                                try {
                                    namedValue.send(this.out);
                                }
                                catch (Exception exception) {
                                    throw new MARSHAL("Couldn't return (in)out arg of type " + namedValue.value().type() + " in ServerRequest.");
                                }
                            }
                        }
                    }
                }
                if (this.replyStatus == 3) {
                    this.out.write_Object(this.location_forward.forward_reference);
                } else if (this.replyStatus == 2) {
                    SystemExceptionHelper.write(this.out, this.sys_ex);
                }
                this.connection.sendReply(this.out);
            }
            catch (Exception exception) {
                this.logger.info("Error replying to request!", exception);
            }
        }
    }

    public OutputStream createReply() {
        this.isStreamBased = true;
        if (this.out != null) {
            return this.out;
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.out.updateMutatorConnection(this.connection);
        this.out.configure(this.orb.getConfiguration());
        return this.out;
    }

    public OutputStream createExceptionReply() {
        this.isStreamBased = true;
        this.replyStatus = 1;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.USER_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        return this.out;
    }

    public void setSystemException(SystemException systemException) {
        this.replyStatus = 2;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.SYSTEM_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        String string = systemException.getMessage();
        if (string != null) {
            this.out.addServiceContext(ServerRequest.createExceptionDetailMessage(string));
        }
        this.sys_ex = systemException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createExceptionDetailMessage(String string) {
        CDROutputStream cDROutputStream = new CDROutputStream();
        try {
            cDROutputStream.beginEncapsulatedArray();
            cDROutputStream.write_wstring(string);
            ServiceContext serviceContext = new ServiceContext(14, cDROutputStream.getBufferCopy());
            return serviceContext;
        }
        finally {
            cDROutputStream.close();
        }
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest forwardRequest) {
        this.replyStatus = 3;
        this.out = new ReplyOutputStream(this.requestId(), ReplyStatusType_1_2.LOCATION_FORWARD, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.location_forward = forwardRequest;
    }

    public CDRInputStream getInputStream() {
        this.isStreamBased = true;
        return this.inputStream;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.isStreamBased = true;
        return this.out;
    }

    public boolean responseExpected() {
        return Messages.responseExpected(this.inputStream.req_hdr.response_flags);
    }

    public short syncScope() {
        short s;
        switch (this.inputStream.req_hdr.response_flags) {
            case 0: {
                s = 0;
                break;
            }
            case 1: {
                s = 2;
                break;
            }
            case 3: {
                s = 3;
                break;
            }
            default: {
                throw new BAD_PARAM("Illegal SYNC_SCOPE: " + this.inputStream.req_hdr.response_flags);
            }
        }
        return s;
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public int requestId() {
        return this.inputStream.req_hdr.request_id;
    }

    public byte[] objectKey() {
        return this.object_key;
    }

    public List getScopes() {
        if (this.scopes == null || !this.cachePoaNames) {
            this.scopes = POAUtil.extractScopedPOANames(POAUtil.extractPOAName(this.object_key));
        }
        return this.scopes;
    }

    public ServiceContext[] getServiceContext() {
        return this.inputStream.req_hdr.service_context;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public boolean streamBased() {
        return this.isStreamBased;
    }

    public void setReference(Object object) {
        this.reference = object;
    }

    public Object getReference() {
        return this.reference;
    }

    public RequestInputStream get_in() {
        return this.inputStream;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.requestId(), this.status(), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        }
        return this.out;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl serverRequestInfoImpl) {
        this.info = serverRequestInfoImpl;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        return null;
    }

    public GIOPConnection getConnection() {
        return this.connection;
    }

    public void setUsePreconstructedReply(boolean bl) {
        this.usePreconstructedReply = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcTimingPolicies() {
        ServiceContext serviceContext = this.inputStream.getServiceContext(7);
        if (serviceContext != null) {
            CDRInputStream cDRInputStream = new CDRInputStream(null, serviceContext.context_data);
            try {
                cDRInputStream.openEncapsulatedArray();
                PolicyValue[] policyValueArray = PolicyValueSeqHelper.read(cDRInputStream);
                for (int i = 0; i < policyValueArray.length; ++i) {
                    if (policyValueArray[i].ptype == 27) {
                        this.requestStartTime = Time.fromCDR(policyValueArray[i].pvalue);
                        continue;
                    }
                    if (policyValueArray[i].ptype == 28) {
                        this.requestEndTime = Time.fromCDR(policyValueArray[i].pvalue);
                        continue;
                    }
                    if (policyValueArray[i].ptype != 30) continue;
                    this.replyEndTime = Time.fromCDR(policyValueArray[i].pvalue);
                }
            }
            finally {
                cDRInputStream.close();
            }
        }
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public UtcT getRequestEndTime() {
        return this.requestEndTime;
    }

    public UtcT getRequestStartTime() {
        return this.requestStartTime;
    }
}

