/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.portableInterceptor.DefaultServerInterceptor;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class BiDirConnectionServerInterceptor
extends DefaultServerInterceptor {
    private static final String NAME = "BiDirConnectionServerInterceptor";
    private final ORB orb;
    private final Logger logger;
    private final ClientConnectionManager conn_mg;

    protected BiDirConnectionServerInterceptor(ORB oRB) {
        this.orb = oRB;
        this.logger = oRB.getConfiguration().getLogger("jacorb.giop.bidir.interceptor");
        this.conn_mg = oRB.getClientConnectionManager();
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        if (this.orb.useBiDirGIOP()) {
            try {
                ServiceContext serviceContext = serverRequestInfo.get_request_service_context(5);
                this.addConnections(serverRequestInfo, serviceContext);
            }
            catch (BAD_PARAM bAD_PARAM) {
                this.logger.debug("no BiDir context present");
            }
        }
    }

    private void addConnections(ServerRequestInfo serverRequestInfo, ServiceContext serviceContext) {
        BiDirIIOPServiceContext biDirIIOPServiceContext = this.readBiDirContext(serviceContext);
        GIOPConnection gIOPConnection = ((ServerRequestInfoImpl)serverRequestInfo).request.getConnection();
        for (int i = 0; i < biDirIIOPServiceContext.listen_points.length; ++i) {
            ListenPoint listenPoint = biDirIIOPServiceContext.listen_points[i];
            IIOPAddress iIOPAddress = new IIOPAddress(listenPoint.host, listenPoint.port);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Client conn. added to target " + iIOPAddress);
            }
            this.conn_mg.addConnection(gIOPConnection, new IIOPProfile(iIOPAddress, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BiDirIIOPServiceContext readBiDirContext(ServiceContext serviceContext) {
        CDRInputStream cDRInputStream = new CDRInputStream(this.orb, serviceContext.context_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            BiDirIIOPServiceContext biDirIIOPServiceContext = BiDirIIOPServiceContextHelper.read(cDRInputStream);
            return biDirIIOPServiceContext;
        }
        finally {
            cDRInputStream.close();
        }
    }
}

