/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import java.util.Hashtable;
import org.jacorb.orb.ORB;
import org.jacorb.slf4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.otid_t;

public class TransactionCurrentImpl
extends LocalObject
implements Current {
    private static final int DEFAULT_TIMEOUT = 30;
    private Hashtable contexts = null;
    private Hashtable timeouts = null;
    private ORB orb = null;
    private static int slot_id = -1;
    private static Logger logger;
    private TransactionFactory factory = null;

    public TransactionCurrentImpl(ORB oRB, int n) {
        this.orb = oRB;
        slot_id = n;
        logger = oRB.getConfiguration().getLogger("jacorb.tx_service.current");
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
        try {
            NamingContextExt namingContextExt = NamingContextExtHelper.narrow(oRB.resolve_initial_references("NameService"));
            NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent("TransactionService", "service")};
            this.factory = TransactionFactoryHelper.narrow(namingContextExt.resolve(nameComponentArray));
        }
        catch (Exception exception) {
            if (logger.isErrorEnabled()) {
                logger.error("Unable to obtain Transaction Service reference. Giving up.", exception);
            }
            throw new Error(exception.getMessage());
        }
    }

    public TransactionCurrentImpl() {
        this.contexts = new Hashtable();
        this.timeouts = new Hashtable();
    }

    public static Control getControl(org.omg.CORBA.ORB oRB) {
        try {
            org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)oRB.resolve_initial_references("PICurrent");
            PropagationContext propagationContext = PropagationContextHelper.extract(current.get_slot(slot_id));
            return ControlHelper.extract(propagationContext.implementation_specific_data);
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to obtain Transaction Service reference. Giving up.", exception);
            }
            return null;
        }
    }

    public void begin() throws SubtransactionsUnavailable {
        block3: {
            Thread thread = Thread.currentThread();
            if (this.contexts.containsKey(thread)) {
                throw new SubtransactionsUnavailable();
            }
            int n = this.timeouts.containsKey(thread) ? (Integer)this.timeouts.get(thread) : 30;
            Control control = this.factory.create(n);
            this.contexts.put(thread, control);
            try {
                org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                TransIdentity transIdentity = new TransIdentity(control.get_coordinator(), control.get_terminator(), new otid_t(0, 0, new byte[0]));
                Any any = this.orb.create_any();
                ControlHelper.insert(any, control);
                PropagationContext propagationContext = new PropagationContext(n, transIdentity, new TransIdentity[0], any);
                Any any2 = this.orb.create_any();
                PropagationContextHelper.insert(any2, propagationContext);
                current.set_slot(slot_id, any2);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", exception);
            }
        }
    }

    public void commit(boolean bl) throws NoTransaction, HeuristicMixed, HeuristicHazard {
        block5: {
            Thread thread = Thread.currentThread();
            if (!this.contexts.containsKey(thread)) {
                throw new NoTransaction();
            }
            Control control = null;
            try {
                control = (Control)this.contexts.get(thread);
                control.get_terminator().commit(bl);
                control._release();
                this.removeContext(thread);
            }
            catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                if (logger.isDebugEnabled()) {
                    logger.debug("TRANSACTION_ROLLEDBACK: ", tRANSACTION_ROLLEDBACK);
                }
                control._release();
                this.removeContext(thread);
                throw tRANSACTION_ROLLEDBACK;
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Exception: ", exception);
            }
        }
    }

    public Control get_control() {
        return (Control)this.contexts.get(Thread.currentThread());
    }

    public Status get_status() {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(thread)).get_coordinator().get_status();
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception: ", exception);
            }
            return null;
        }
    }

    public String get_transaction_name() {
        Thread thread = Thread.currentThread();
        if (!this.contexts.containsKey(thread)) {
            return null;
        }
        try {
            return ((Control)this.contexts.get(thread)).get_coordinator().get_transaction_name();
        }
        catch (Exception exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception: ", exception);
            }
            return null;
        }
    }

    public void resume(Control control) throws InvalidControl {
        this.setCurrentThreadContext(control);
    }

    public void rollback() throws NoTransaction {
        block3: {
            Thread thread = Thread.currentThread();
            if (!this.contexts.containsKey(thread)) {
                throw new NoTransaction();
            }
            try {
                Control control = (Control)this.contexts.get(thread);
                control.get_terminator().rollback();
                control._release();
                this.removeContext(thread);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", exception);
            }
        }
    }

    public void rollback_only() throws NoTransaction {
        block3: {
            Thread thread = Thread.currentThread();
            if (!this.contexts.containsKey(thread)) {
                throw new NoTransaction();
            }
            try {
                Control control = (Control)this.contexts.get(thread);
                control.get_coordinator().rollback_only();
                control._release();
                this.removeContext(thread);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Exception: ", exception);
            }
        }
    }

    public void set_timeout(int n) {
        this.timeouts.put(Thread.currentThread(), new Integer(n));
    }

    public Control suspend() {
        Control control = this.get_control();
        this.removeContext(Thread.currentThread());
        return control;
    }

    public void setCurrentThreadContext(Control control) {
        block2: {
            Thread thread = Thread.currentThread();
            this.contexts.put(thread, control);
            try {
                org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                TransIdentity transIdentity = new TransIdentity(control.get_coordinator(), control.get_terminator(), new otid_t(0, 0, new byte[0]));
                Any any = this.orb.create_any();
                ControlHelper.insert(any, control);
                int n = this.timeouts.containsKey(thread) ? (Integer)this.timeouts.get(thread) : 30;
                PropagationContext propagationContext = new PropagationContext(n, transIdentity, new TransIdentity[0], any);
                Any any2 = this.orb.create_any();
                PropagationContextHelper.insert(any2, propagationContext);
                current.set_slot(slot_id, any2);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Exception: ", exception);
            }
        }
    }

    private void removeContext(Thread thread) {
        block2: {
            this.contexts.remove(thread);
            try {
                org.omg.PortableInterceptor.Current current = (org.omg.PortableInterceptor.Current)this.orb.resolve_initial_references("PICurrent");
                Any any = this.orb.create_any();
                current.set_slot(slot_id, any);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Exception: ", exception);
            }
        }
    }
}

