/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.JoramAdmin;
import org.objectweb.joram.client.jms.admin.JoramAdminConnectMBean;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JoramAdminConnect
implements JoramAdminConnectMBean {
    public static Logger logger = Debug.getLogger((String)JoramAdminConnect.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            MXWrapper.init();
            JoramAdminConnect admin = new JoramAdminConnect();
            admin.registerMBean();
            JoramAdminConnect joramAdminConnect = admin;
            synchronized (joramAdminConnect) {
                admin.wait();
            }
            admin.unregisterMBean();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void registerMBean() {
        block3: {
            if (MXWrapper.mxserver == null) {
                return;
            }
            try {
                MXWrapper.registerMBean((Object)this, (String)"JoramAdmin", (String)"type=AdminConnect");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.registerMBean", (Throwable)e);
            }
        }
    }

    public void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean((String)"JoramAdmin", (String)"type=AdminConnect");
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)"JoramAdmin.unregisterMBean", (Throwable)e);
            }
        }
    }

    public void connect(String name) throws ConnectException, AdminException {
        this.connect(name, "localhost", 16010, "root", "root");
    }

    public void connect(String name, String host, int port, String user, String pass) throws ConnectException, AdminException {
        ConnectionFactory cf = TcpConnectionFactory.create(host, port);
        try {
            Connection cnx = cf.createConnection(user, pass);
            cnx.start();
            new JoramAdmin(cnx, name);
        }
        catch (JMSException exc) {
            exc.printStackTrace();
        }
    }

    public synchronized void exit(boolean force) {
        if (force) {
            System.exit(0);
        } else {
            this.notify();
        }
    }
}

