/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedList<T>
implements Cloneable,
Serializable,
Iterable<Map.Entry<String, T>> {
    protected final List nvPairs;

    public NamedList() {
        this.nvPairs = new ArrayList();
    }

    public NamedList(List nameValuePairs) {
        this.nvPairs = nameValuePairs;
    }

    public int size() {
        return this.nvPairs.size() >> 1;
    }

    public String getName(int idx) {
        return (String)this.nvPairs.get(idx << 1);
    }

    public T getVal(int idx) {
        return (T)this.nvPairs.get((idx << 1) + 1);
    }

    public void add(String name, T val) {
        this.nvPairs.add(name);
        this.nvPairs.add(val);
    }

    public void setName(int idx, String name) {
        this.nvPairs.set(idx << 1, name);
    }

    public T setVal(int idx, T val) {
        int index = (idx << 1) + 1;
        Object old = this.nvPairs.get(index);
        this.nvPairs.set(index, val);
        return (T)old;
    }

    public int indexOf(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return i;
        }
        return -1;
    }

    public T get(String name) {
        return this.get(name, 0);
    }

    public T get(String name, int start) {
        int sz = this.size();
        for (int i = start; i < sz; ++i) {
            String n = this.getName(i);
            if (!(name == null ? n == null : name.equals(n))) continue;
            return this.getVal(i);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.getName(i));
            sb.append('=');
            sb.append(this.getVal(i));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean addAll(Map<String, T> args) {
        for (Map.Entry<String, T> entry : args.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return args.size() > 0;
    }

    public boolean addAll(NamedList<T> nl) {
        this.nvPairs.addAll(nl.nvPairs);
        return nl.size() > 0;
    }

    public NamedList<T> clone() {
        ArrayList newList = new ArrayList(this.nvPairs.size());
        newList.addAll(this.nvPairs);
        return new NamedList<T>(newList);
    }

    @Override
    public Iterator<Map.Entry<String, T>> iterator() {
        final NamedList list = this;
        Iterator iter = new Iterator<Map.Entry<String, T>>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < list.size();
            }

            @Override
            public Map.Entry<String, T> next() {
                final int index = this.idx++;
                Map.Entry nv = new Map.Entry<String, T>(){

                    @Override
                    public String getKey() {
                        return list.getName(index);
                    }

                    @Override
                    public T getValue() {
                        return list.getVal(index);
                    }

                    public String toString() {
                        return this.getKey() + "=" + this.getValue();
                    }

                    @Override
                    public T setValue(T value) {
                        return list.setVal(index, value);
                    }
                };
                return nv;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iter;
    }
}

