/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.solr.core.Config;

public class TransformerProvider {
    public static TransformerProvider instance = new TransformerProvider();
    private final TransformerFactory tFactory = TransformerFactory.newInstance();
    private String lastFilename;
    private Templates lastTemplates = null;
    private long cacheExpires = 0L;
    private static Logger log;

    private TransformerProvider() {
        log = Logger.getLogger(TransformerProvider.class.getName());
        log.warning("The TransformerProvider's simplistic XSLT caching mechanism is not appropriate for high load scenarios, unless a single XSLT transform is used and xsltCacheLifetimeSeconds is set to a sufficiently high value.");
    }

    public synchronized Transformer getTransformer(String filename, int cacheLifetimeSeconds) throws IOException {
        if (this.lastTemplates != null && filename.equals(this.lastFilename) && System.currentTimeMillis() < this.cacheExpires) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using cached Templates:" + filename);
            }
        } else {
            this.lastTemplates = this.getTemplates(filename, cacheLifetimeSeconds);
        }
        Transformer result = null;
        try {
            result = this.lastTemplates.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            log.throwing(this.getClass().getName(), "getTransformer", tce);
            IOException ioe = new IOException("newTransformer fails ( " + this.lastFilename + ")");
            ioe.initCause(tce);
            throw ioe;
        }
        return result;
    }

    private Templates getTemplates(String filename, int cacheLifetimeSeconds) throws IOException {
        Templates result = null;
        this.lastFilename = null;
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("compiling XSLT templates:" + filename);
            }
            InputStream xsltStream = Config.openResource("xslt/" + filename);
            result = this.tFactory.newTemplates(new StreamSource(xsltStream));
        }
        catch (Exception e) {
            log.throwing(this.getClass().getName(), "newTemplates", e);
            IOException ioe = new IOException("Unable to initialize Templates '" + filename + "'");
            ioe.initCause(e);
            throw ioe;
        }
        this.lastFilename = filename;
        this.lastTemplates = result;
        this.cacheExpires = System.currentTimeMillis() + (long)(cacheLifetimeSeconds * 1000);
        return result;
    }
}

