/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.jboss.util.file.ArchiveBrowser;
import org.osgi.framework.BundleContext;
import org.ow2.easybeans.osgi.util.BCMapper;

public class BundleArchiveBrowser
implements Iterator {
    Enumeration entries = null;
    URL next = null;
    ArchiveBrowser.Filter filter = null;

    public BundleArchiveBrowser(URL url, ArchiveBrowser.Filter filter) {
        BCMapper mapper = BCMapper.getInstance();
        BundleContext bc = (BundleContext)mapper.get((Object)url);
        this.entries = bc.getBundle().findEntries("", "*", true);
        this.filter = filter;
        this.setNext();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    private void setNext() {
        this.next = null;
        while (this.entries.hasMoreElements() && this.next == null) {
            this.next = (URL)this.entries.nextElement();
            if (this.next == null || this.filter.accept(this.next.getFile())) continue;
            this.next = null;
        }
    }

    public Object next() {
        URL entry = this.next;
        this.setNext();
        try {
            return entry.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        throw new RuntimeException("Illegal operation on ArchiveBrowser");
    }
}

